/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.model;

import java.util.Iterator;

import junit.framework.TestCase;
import benten.twa.filter.model.HtmlInlineTextBuilder.InlineText;

public class HtmlInlineTextBuilderTest extends TestCase {

	public void testIterate() {
		try {
			new HtmlInlineTextBuilder((String) null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		StringBuilder sb = new StringBuilder();
		sb.append("<html>");
		sb.append("<body>");
		sb.append("test text. ");
		sb.append("<a>link text</a>. ");
		sb.append("<p>p text.</p>");
		sb.append("</body>");
		sb.append("</html>");

		final HtmlInlineTextBuilder builder = new HtmlInlineTextBuilder(sb.toString());
		final Iterator<InlineText> it = builder.iterator();

		assertTrue(it.hasNext());
		InlineText text = it.next();
		assertEquals("test text. <a>link text</a>.", text.getText());
		text.setText("テスト・テキスト。<a>リンク・テキスト</a>。");

		assertTrue(it.hasNext());
		text = it.next();
		assertEquals("p text.", text.getText());
		text.setText("p テキスト。");

		assertFalse(it.hasNext());

		sb = new StringBuilder();
		sb.append("<html>");
		sb.append("<body>");
		sb.append("テスト・テキスト。");
		sb.append("<a>リンク・テキスト</a>。 ");
		sb.append("<p>p テキスト。</p>");
		sb.append("</body>");
		sb.append("</html>");

		assertEquals(sb.toString(), builder.getResultString("UTF-8"));
	}
}
