/*******************************************************************************
 * Copyright (c) 2010 IGA Tosiki.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
/*
 * Copyright (C) 2010 IGA Tosiki.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package benten.twa.filter.engine.po;

import java.util.ArrayList;
import java.util.List;

/**
 * 単純な PO エントリー。
 * 
 * @author IGA Tosiki
 */
class SimplePOEntry {
	/**
	 * msgid か msgstr
	 */
	private String fCommand = null;

	private final List<String> fStringLiteralList = new ArrayList<String>();
	private final List<String> fCommentList = new ArrayList<String>();

	/**
	 * コマンド文字列の取得。
	 * @return コマンド文字列。
	 */
	public String getCommand() {
		return fCommand;
	}

	/**
	 * コマンド文字列の設定。
	 * @param command コマンド文字列。
	 */
	public void setCommand(final String command) {
		this.fCommand = command;
	}

	/**
	 * 文字列リテラルのリストを取得。
	 * @return 文字列リテラルのリスト。 
	 */
	public List<String> getStringLiteralList() {
		return fStringLiteralList;
	}

	/**
	 * コメントのリストを取得。
	 * @return コメントのリスト。
	 */
	public List<String> getCommentList() {
		return fCommentList;
	}
}
