/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.io;

import java.math.BigDecimal;

import junit.framework.TestCase;
import benten.twa.io.messages.BentenTwaProcessUtilMessages;
import benten.twa.process.BentenProcessResultInfo;

public class BentenTwaProcessUtilTest extends TestCase {

	public void testGetResultMessage() {

		try {
			BentenTwaProcessUtil.getResultMessage(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		final BentenTwaProcessUtilMessages msg = BentenTwaProcessUtil.fMsg;
		final BentenProcessResultInfo info = new BentenProcessResultInfo();
		String message = BentenTwaProcessUtil.getResultMessage(info);
		assertTrue(message.contains(msg.getMsgSuccess(BigDecimal.valueOf(info.getSuccessCount()))));
		assertFalse(message.contains(msg.getMsgWarning(BigDecimal.valueOf(info.getWarningCount()))));
		assertFalse(message.contains(msg.getMsgSkipped(BigDecimal.valueOf(info.getSkipCount()))));
		assertFalse(message.contains(msg.getMsgUnitSuccess(BigDecimal.valueOf(info.getUnitCount()))));

		info.setWarningCount(1);
		message = BentenTwaProcessUtil.getResultMessage(info);
		assertTrue(message.contains(msg.getMsgSuccess(BigDecimal.valueOf(info.getSuccessCount()))));
		assertTrue(message.contains(msg.getMsgWarning(BigDecimal.valueOf(info.getWarningCount()))));
		assertFalse(message.contains(msg.getMsgSkipped(BigDecimal.valueOf(info.getSkipCount()))));
		assertFalse(message.contains(msg.getMsgUnitSuccess(BigDecimal.valueOf(info.getUnitCount()))));

		info.setSkipCount(1);
		message = BentenTwaProcessUtil.getResultMessage(info);
		assertTrue(message.contains(msg.getMsgSuccess(BigDecimal.valueOf(info.getSuccessCount()))));
		assertTrue(message.contains(msg.getMsgWarning(BigDecimal.valueOf(info.getWarningCount()))));
		assertTrue(message.contains(msg.getMsgSkipped(BigDecimal.valueOf(info.getSkipCount()))));
		assertFalse(message.contains(msg.getMsgUnitSuccess(BigDecimal.valueOf(info.getUnitCount()))));

		info.setUnitCount(1);
		message = BentenTwaProcessUtil.getResultMessage(info);
		assertTrue(message.contains(msg.getMsgSuccess(BigDecimal.valueOf(info.getSuccessCount()))));
		assertTrue(message.contains(msg.getMsgWarning(BigDecimal.valueOf(info.getWarningCount()))));
		assertTrue(message.contains(msg.getMsgSkipped(BigDecimal.valueOf(info.getSkipCount()))));
		assertTrue(message.contains(msg.getMsgUnitSuccess(BigDecimal.valueOf(info.getUnitCount()))));
	}
}
