package benten.twa.ui.dialogs;

import java.io.ByteArrayInputStream;

import junit.framework.TestCase;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.ui.UiPlugin;
import benten.ui.UiStatusException;
import benten.ui.fields.AbstractBrowseTextField;
import benten.ui.fields.FileTextField;
import benten.ui.fields.FolderTextField;
import benten.ui.fields.IBrowseTextField;

public class AbstractWorkflowDialogTest extends TestCase {

	private final AbstractWorkflowDialog target = new AbstractWorkflowDialog(null, new StructuredSelection(), null) {
		@Override
		public void createControls(final Composite composite) {
		}
		@Override
		public IStatus getResultStatus() {
			return null;
		}
		@Override
		public IStatus validate() throws UiStatusException {
			return null;
		}
	};

	private boolean validatePath(final IBrowseTextField field, final String value) {
		AbstractBrowseTextField.clearPreviousInput();
		field.setText(value);
		System.out.println(field.getText());
		String message = null;
		try {
			target.validatePath(field);
			return true;
		} catch (final UiStatusException e) {
			message = e.getMessage();
		}
		return !message.contains(field.getLabelText());
	}

	//-------------------------------------------------------------------------

	public void testValidatePath() throws CoreException {

		// ワークスペースにテスト用のプロジェクトを作成
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");
		if (!project.exists()) {
			project.create(null);
		}
		project.open(null);
		final IFile file = project.getFile(new Path("test.file"));
		if (!file.exists()) {
			file.create(new ByteArrayInputStream("".getBytes()), true, null);
		}
		final IFolder folder = project.getFolder(new Path("test.folder"));
		if (!folder.exists()) {
			folder.create(true, true, null);
		}
		IBrowseTextField field = null;

		field = new FileTextField(UiPlugin.getShell(), String.valueOf(System.nanoTime()));
		assertFalse(validatePath(field, ""));
		assertFalse(validatePath(field, root.getLocation() + ".先頭ピリオド"));
		assertFalse(validatePath(field, root.getLocation() + "末尾ピリオド."));
		assertFalse(validatePath(field, root.getLocation() + "存在しないリソース"));
		assertFalse(validatePath(field, root.getLocation() + "/test.project"));
		assertTrue(validatePath(field, root.getLocation() + "/test.project/test.file"));
		assertFalse(validatePath(field, root.getLocation() + "/test.project/test.folder"));

		field = new FolderTextField(UiPlugin.getShell(), String.valueOf(System.nanoTime()));
		assertFalse(validatePath(field, ""));
		assertFalse(validatePath(field, root.getLocation() + ".先頭ピリオド"));
		assertFalse(validatePath(field, root.getLocation() + "末尾ピリオド."));
		assertFalse(validatePath(field, root.getLocation() + "存在しないリソース"));
		assertTrue(validatePath(field, root.getLocation() + "/test.project"));
		assertTrue(validatePath(field, root.getLocation() + "/test.project/test.file")); // 親フォルダーになる
		assertTrue(validatePath(field, root.getLocation() + "/test.project/test.folder"));
	}
}
