/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.tmx.core.valueobject;

/**
 * 処理クラス [BentenExtractTmxFragmentProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenExtractTmxFragmentProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * 抽出元となる XLIFF ディレクトリ。
     *
     * フィールド: [xliffdir]。
     */
    private String fXliffdir;

    /**
     * 抽出先となる TMX を格納するディレクトリ。
     *
     * フィールド: [tmxdir]。
     */
    private String fTmxdir;

    /**
     * 翻訳対象 id  を格納します。この id はファイル名の一部に利用されます。
     *
     * フィールド: [transtargetid]。
     */
    private String fTranstargetid;

    /**
     * 状態で抽出する場合の state 値。無指定なら state で抽出しない。target無しで絞り込みたい場合には、半角空白 1 つをセット。
     *
     * フィールド: [extractbystate]。
     */
    private String fExtractbystate;

    /**
     * 出力ファイル名に日付を含めるかどうか。
     *
     * フィールド: [includedate]。
     * デフォルト: [false]。
     */
    private boolean fIncludedate = false;

    /**
     * ホワイトスペースを無視した内容の TMX を抽出するかどうか。HTML の場合には true を推奨。
     *
     * フィールド: [ignorewhitespacetmxextract]。
     * デフォルト: [false]。
     */
    private boolean fIgnorewhitespacetmxextract = false;

    /**
     * ニーモニック・キーを無視した内容の TMX を抽出するかどうか。日本風のニーモニックのみ対応。
     *
     * フィールド: [ignoremnemonickeytmxextract]。
     * デフォルト: [false]。
     */
    private boolean fIgnoremnemonickeytmxextract = false;

    /**
     * 翻訳元言語。TMX ヘッダーに使われます。
     *
     * フィールド: [transsourcelang]。
     * デフォルト: [en-US]。
     */
    private String fTranssourcelang = "en-US";

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [xliffdir] の値を設定します。
     *
     * フィールドの説明: [抽出元となる XLIFF ディレクトリ。]。
     *
     * @param argXliffdir フィールド[xliffdir]に設定する値。
     */
    public void setXliffdir(final String argXliffdir) {
        fXliffdir = argXliffdir;
    }

    /**
     * フィールド [xliffdir] の値を取得します。
     *
     * フィールドの説明: [抽出元となる XLIFF ディレクトリ。]。
     *
     * @return フィールド[xliffdir]から取得した値。
     */
    public String getXliffdir() {
        return fXliffdir;
    }

    /**
     * フィールド [tmxdir] の値を設定します。
     *
     * フィールドの説明: [抽出先となる TMX を格納するディレクトリ。]。
     *
     * @param argTmxdir フィールド[tmxdir]に設定する値。
     */
    public void setTmxdir(final String argTmxdir) {
        fTmxdir = argTmxdir;
    }

    /**
     * フィールド [tmxdir] の値を取得します。
     *
     * フィールドの説明: [抽出先となる TMX を格納するディレクトリ。]。
     *
     * @return フィールド[tmxdir]から取得した値。
     */
    public String getTmxdir() {
        return fTmxdir;
    }

    /**
     * フィールド [transtargetid] の値を設定します。
     *
     * フィールドの説明: [翻訳対象 id  を格納します。この id はファイル名の一部に利用されます。]。
     *
     * @param argTranstargetid フィールド[transtargetid]に設定する値。
     */
    public void setTranstargetid(final String argTranstargetid) {
        fTranstargetid = argTranstargetid;
    }

    /**
     * フィールド [transtargetid] の値を取得します。
     *
     * フィールドの説明: [翻訳対象 id  を格納します。この id はファイル名の一部に利用されます。]。
     *
     * @return フィールド[transtargetid]から取得した値。
     */
    public String getTranstargetid() {
        return fTranstargetid;
    }

    /**
     * フィールド [extractbystate] の値を設定します。
     *
     * フィールドの説明: [状態で抽出する場合の state 値。無指定なら state で抽出しない。target無しで絞り込みたい場合には、半角空白 1 つをセット。]。
     *
     * @param argExtractbystate フィールド[extractbystate]に設定する値。
     */
    public void setExtractbystate(final String argExtractbystate) {
        fExtractbystate = argExtractbystate;
    }

    /**
     * フィールド [extractbystate] の値を取得します。
     *
     * フィールドの説明: [状態で抽出する場合の state 値。無指定なら state で抽出しない。target無しで絞り込みたい場合には、半角空白 1 つをセット。]。
     *
     * @return フィールド[extractbystate]から取得した値。
     */
    public String getExtractbystate() {
        return fExtractbystate;
    }

    /**
     * フィールド [includedate] の値を設定します。
     *
     * フィールドの説明: [出力ファイル名に日付を含めるかどうか。]。
     *
     * @param argIncludedate フィールド[includedate]に設定する値。
     */
    public void setIncludedate(final boolean argIncludedate) {
        fIncludedate = argIncludedate;
    }

    /**
     * フィールド [includedate] の値を取得します。
     *
     * フィールドの説明: [出力ファイル名に日付を含めるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[includedate]から取得した値。
     */
    public boolean getIncludedate() {
        return fIncludedate;
    }

    /**
     * フィールド [ignorewhitespacetmxextract] の値を設定します。
     *
     * フィールドの説明: [ホワイトスペースを無視した内容の TMX を抽出するかどうか。HTML の場合には true を推奨。]。
     *
     * @param argIgnorewhitespacetmxextract フィールド[ignorewhitespacetmxextract]に設定する値。
     */
    public void setIgnorewhitespacetmxextract(final boolean argIgnorewhitespacetmxextract) {
        fIgnorewhitespacetmxextract = argIgnorewhitespacetmxextract;
    }

    /**
     * フィールド [ignorewhitespacetmxextract] の値を取得します。
     *
     * フィールドの説明: [ホワイトスペースを無視した内容の TMX を抽出するかどうか。HTML の場合には true を推奨。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignorewhitespacetmxextract]から取得した値。
     */
    public boolean getIgnorewhitespacetmxextract() {
        return fIgnorewhitespacetmxextract;
    }

    /**
     * フィールド [ignoremnemonickeytmxextract] の値を設定します。
     *
     * フィールドの説明: [ニーモニック・キーを無視した内容の TMX を抽出するかどうか。日本風のニーモニックのみ対応。]。
     *
     * @param argIgnoremnemonickeytmxextract フィールド[ignoremnemonickeytmxextract]に設定する値。
     */
    public void setIgnoremnemonickeytmxextract(final boolean argIgnoremnemonickeytmxextract) {
        fIgnoremnemonickeytmxextract = argIgnoremnemonickeytmxextract;
    }

    /**
     * フィールド [ignoremnemonickeytmxextract] の値を取得します。
     *
     * フィールドの説明: [ニーモニック・キーを無視した内容の TMX を抽出するかどうか。日本風のニーモニックのみ対応。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignoremnemonickeytmxextract]から取得した値。
     */
    public boolean getIgnoremnemonickeytmxextract() {
        return fIgnoremnemonickeytmxextract;
    }

    /**
     * フィールド [transsourcelang] の値を設定します。
     *
     * フィールドの説明: [翻訳元言語。TMX ヘッダーに使われます。]。
     *
     * @param argTranssourcelang フィールド[transsourcelang]に設定する値。
     */
    public void setTranssourcelang(final String argTranssourcelang) {
        fTranssourcelang = argTranssourcelang;
    }

    /**
     * フィールド [transsourcelang] の値を取得します。
     *
     * フィールドの説明: [翻訳元言語。TMX ヘッダーに使われます。]。
     * デフォルト: [en-US]。
     *
     * @return フィールド[transsourcelang]から取得した値。
     */
    public String getTranssourcelang() {
        return fTranssourcelang;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.tmx.core.valueobject.BentenExtractTmxFragmentProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",xliffdir=" + fXliffdir);
        buf.append(",tmxdir=" + fTmxdir);
        buf.append(",transtargetid=" + fTranstargetid);
        buf.append(",extractbystate=" + fExtractbystate);
        buf.append(",includedate=" + fIncludedate);
        buf.append(",ignorewhitespacetmxextract=" + fIgnorewhitespacetmxextract);
        buf.append(",ignoremnemonickeytmxextract=" + fIgnoremnemonickeytmxextract);
        buf.append(",transsourcelang=" + fTranssourcelang);
        buf.append("]");
        return buf.toString();
    }
}
