/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.core;

import java.util.ArrayList;
import java.util.List;

import blanco.tmx.valueobject.BlancoTmxTu;

/**
 * Benten TMX TU ユーティリティーです。
 * 
 * @author IGA Tosiki
 */
public class BentenTmxTuUtil {

	/**
	 * 重複する tuv を除去します。
	 *
	 * 前提条件: tuv が所定のルールでソートされていること。
	 * 前提条件: tuv が 2 個であること。
	 *
	 * @param list 処理対象となる tu のリスト。
	 */
	public static void removeDuplicatedTuv(final List<BlancoTmxTu> list) {
		final List<BlancoTmxTu> removeList = new ArrayList<BlancoTmxTu>();

		String prevSeg1 = ""; //$NON-NLS-1$
		String prevSeg2 = ""; //$NON-NLS-1$
		for (final BlancoTmxTu tu : list) {
			if (tu.getTuvList().size() != 2) {
				// seg が 2個以外のものは処理しません。
				continue;
			}

			final String seg1 = tu.getTuvList().get(0).getSeg();
			final String seg2 = tu.getTuvList().get(1).getSeg();

			if (seg1.equals(prevSeg1) && seg2.equals(prevSeg2)) {
				// 重複した登録です。これは除去する対象であるとマークします。
				removeList.add(tu);
			}

			prevSeg1 = seg1;
			prevSeg2 = seg2;
		}

		for (final BlancoTmxTu tu : removeList) {
			// 実際の除去作業を実施します。
			list.remove(tu);
		}
	}
}
