/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.wizards;

import benten.twa.tmx.handler.MergeTmxHandler;
import benten.twa.tmx.messages.BentenMergeTmxMessages;
import benten.twa.ui.jobs.WorkflowJob;
import benten.twa.ui.wizards.AbstractWorkflowWizard;

/**
 * TMX フラグメントのマージ
 *
 * <pre>
 * TMX フラグメントを TMX にマージします。
 *   1.  TMX の内容を、別の TMX にマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント・マージ機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class MergeTmxWizard extends AbstractWorkflowWizard {
	/**
	 * TMXマージ機能のためのメッセージ。
	 */
	protected static final BentenMergeTmxMessages fMsg = new BentenMergeTmxMessages();

	@Override
	public void addPages() {
		setWindowTitle(fMsg.getWindowTitle());
		addPage(new MergeTmxWizardPage());
		addPage(new MergeTmxWizardPage2(getSelection()));
	}

	@Override
	protected void scheduleJob() {
		final WorkflowJob job = new WorkflowJob(fMsg.getJobName());
		job.addHandler(new MergeTmxHandler(), getStatus());
		job.setCompleteMessage(getWindowTitle(), fMsg.getWizardPage3ResultMessage());
		job.schedule();
	}
}
