/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.tmx.messages.BentenMergeTmxMessages;
import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;

/**
 * TMX フラグメントのマージ
 *
 * <pre>
 * TMX フラグメントを TMX にマージします。
 *   1.  TMX の内容を、別の TMX にマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント・マージ機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class MergeTmxWizardPage extends AbstractWorkflowWellcomeWizardPage {
	/**
	 * TMXマージ機能のためのメッセージ。
	 */
	protected static final BentenMergeTmxMessages fMsg = new BentenMergeTmxMessages();

	/**
	 * コンストラクター。
	 */
	protected MergeTmxWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.WRAP);
		label.setText(fMsg.getWizardPageLabel1());
		final GridData gridDate = new GridData(GridData.FILL_BOTH);
		label.setLayoutData(gridDate);
	}
}
