/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.ui.wizards;

import junit.framework.TestCase;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;

import benten.core.BentenProjectNature;
import benten.twa.BentenTwaConstants;

public class NewProjectCreationWizardTest extends TestCase {

	public void testAddPages() throws CoreException {
		final NewProjectCreationWizard target = new NewProjectCreationWizard();
		target.addPages();

		assertEquals(2, target.getPageCount());
		assertNotNull(target.getWindowTitle());
		
		final IWizardPage page = target.getPage(NewProjectCreationWizardPage.class.getName());
		
		assertNotNull(page);
		assertNotNull(page.getTitle());
		assertNotNull(page.getDescription());
	}

	public void testCreateProject() throws CoreException {

		// プロジェクト作成
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");
		project.delete(true, null);
		new NewProjectCreationWizard().createProject(project);
		assertTrue(true);

		// ネーチャー検査
		assertNotNull(project.getNature(BentenProjectNature.NATURE_ID));

		// ディレクトリー構造検査
		assertTrue(project.getFolder(new Path(BentenTwaConstants.DEFAULT_DIR)).exists());
		assertTrue(project.getFolder(new Path(BentenTwaConstants.DEFAULT_SOURCE_DIR)).exists());
		assertTrue(project.getFolder(new Path(BentenTwaConstants.DEFAULT_XLIFF_DIR)).exists());
		assertTrue(project.getFolder(new Path(BentenTwaConstants.DEFAULT_TMX_DIR)).exists());
		assertTrue(project.getFolder(new Path(BentenTwaConstants.DEFAULT_XLIFF_FRAGMENT_DIR)).exists());
		assertTrue(project.getFolder(new Path(BentenTwaConstants.DEFAULT_TMX_FRAGMENT_DIR)).exists());
	}
}
