package benten.twa.xliff.dialogs;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;

import junit.framework.TestCase;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.ui.wizards.NewProjectCreationWizard;
import benten.twa.xliff.dialogs.MergeXliffDialog.MergeXliffControls;
import benten.ui.UiStatusException;
import benten.ui.fields.AbstractBrowseTextField;
import benten.ui.fields.TextField;

public class MergeXliffDialogTest extends TestCase {

	private final MergeXliffDialog target = new MergeXliffDialog(null, new StructuredSelection());

	private String getValidateMessage() {
		try {
			target.validate();
			return null;
		} catch (final UiStatusException e) {
			return e.getMessage();
		}
	}

	private boolean validate(final TextField field, final String value) {
		AbstractBrowseTextField.clearPreviousInput();
		field.setText(value);
		final String message = getValidateMessage();
		if (message == null) {
			return true;
		}
		return !message.contains(field.getLabelText());
	}

	private boolean validateFromTo(final TextField field1, final TextField field2, final String value1,
			final String value2) {
		AbstractBrowseTextField.clearPreviousInput();
		field1.setText(value1);
		field2.setText(value2);
		final String message = getValidateMessage();
		if (message == null) {
			return true;
		}
		return !(message.contains(field1.getLabelText()) && message.contains(field2.getLabelText()));
	}

	public void testValidate() throws Exception {

		// テスト対象のダイアログからコントロール・コンテナーの取得
		target.createControls(new Composite(new Shell(), SWT.NONE));
		final Field field = target.getClass().getDeclaredField("controls");
		field.setAccessible(true);
		final MergeXliffControls controls = (MergeXliffControls) field.get(target);

		// ワークスペースにテスト用のプロジェクトを作成
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");
		new NewProjectCreationWizard().createProject(project);
		final IFile file = project.getFile(new Path("test.file"));
		if (!file.exists()) {
			file.create(new ByteArrayInputStream("".getBytes()), true, null);
		}

		assertFalse(validate(controls.fromDirText, null));
		assertFalse(validate(controls.fromDirText, ""));
		assertFalse(validate(controls.fromDirText, ".先頭ピリオド"));
		assertFalse(validate(controls.fromDirText, "末尾ピリオド."));
		assertFalse(validate(controls.fromDirText, "存在しないリソース"));
		assertFalse(validate(controls.fromDirText, "test.file"));
		assertTrue(validate(controls.fromDirText, "/test.project/xliff.fragment"));

		assertFalse(validate(controls.toDirText, null));
		assertFalse(validate(controls.toDirText, ""));
		assertFalse(validate(controls.toDirText, ".先頭ピリオド"));
		assertFalse(validate(controls.toDirText, "末尾ピリオド."));
		assertFalse(validate(controls.toDirText, "存在しないリソース"));
		assertFalse(validate(controls.toDirText, "test.file"));
		assertTrue(validate(controls.toDirText, "/test.project/xliff"));

		assertNull(getValidateMessage());

		assertFalse(validateFromTo(controls.fromDirText, controls.toDirText, "/test.project", "/test.project"));
		assertFalse(validateFromTo(controls.fromDirText, controls.toDirText, "/test.project/xliff", "/test.project"));
		assertFalse(validateFromTo(controls.fromDirText, controls.toDirText, "/test.project", "/test.project/xliff"));
	}
}
