/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.xliff.messages;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * XLIFFフラグメント抽出機能のためのメッセージ。
 *
 * リソースバンドル定義: [BentenExtractXliffFragmentMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenExtractXliffFragmentMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenExtractXliffFragmentMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExtractXliffFragmentMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenExtractXliffFragmentMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/xliff/messages/BentenExtractXliffFragmentMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenExtractXliffFragmentMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExtractXliffFragmentMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenExtractXliffFragmentMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/xliff/messages/BentenExtractXliffFragmentMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenExtractXliffFragmentMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenExtractXliffFragmentMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenExtractXliffFragmentMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/xliff/messages/BentenExtractXliffFragmentMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WindowTitle]
     *
     * [Extract XLIFF Fragments] (en)<br>
     * [XLIFF フラグメントの抽出] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract XLIFF Fragments";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[JobName]
     *
     * [Extracting the XLIFF fragments...] (en)<br>
     * [XLIFF フラグメントの抽出中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extracting the XLIFF fragments...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WizardPageTitle]
     *
     * [Welcome] (en)<br>
     * [ようこそ] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Welcome";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WizardPageDescription]
     *
     * [Extract the XLIFF fragments from XLIFF.] (en)<br>
     * [XLIFF から XLIFF フラグメントを抽出します。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract the XLIFF fragments from XLIFF.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WizardPageLabel1]
     *
     * [This wizard extracts the XLIFF fragments from XLIFF.\n\n 1.  Create the XLIFF fragments from XLIFF by extracting the translation unit that meets the given conditions.] (en)<br>
     * [このウィザードは、XLIFF から XLIFF フラグメントを抽出します。\n\n 1.  XLIFF から所定の条件に合う翻訳単位を抽出して XLIFF フラグメントを作成します。] (ja)<br>
     *
     * @return key[WizardPageLabel1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "This wizard extracts the XLIFF fragments from XLIFF.\n\n 1.  Create the XLIFF fragments from XLIFF by extracting the translation unit that meets the given conditions.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageLabel1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WizardPage2Title]
     *
     * [Target File] (en)<br>
     * [対象ファイルの指定] (ja)<br>
     *
     * @return key[WizardPage2Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Title() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target File";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WizardPage2Description]
     *
     * [Specify the target file.] (en)<br>
     * [対象ファイルを指定します。] (ja)<br>
     *
     * @return key[WizardPage2Description]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Description() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Specify the target file.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Description");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[WizardPage3ResultMessage]
     *
     * [Extraction of the XLIFF fragments completed.] (en)<br>
     * [XLIFF フラグメントの抽出が完了しました。] (ja)<br>
     *
     * @return key[WizardPage3ResultMessage]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage3ResultMessage() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extraction of the XLIFF fragments completed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage3ResultMessage");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlLabelFromFile]
     *
     * [Target File] (en)<br>
     * [対象ファイル] (ja)<br>
     *
     * @return key[DialogCtrlLabelFromFile]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelFromFile() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target File";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelFromFile");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlLabelToDir]
     *
     * [Output Destination] (en)<br>
     * [出力先] (ja)<br>
     *
     * @return key[DialogCtrlLabelToDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelToDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Output Destination";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelToDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlGroupExtractMethod]
     *
     * [Extraction Method] (en)<br>
     * [抽出方法] (ja)<br>
     *
     * @return key[DialogCtrlGroupExtractMethod]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlGroupExtractMethod() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extraction Method";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlGroupExtractMethod");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlButtonStateCheck]
     *
     * [Extract by State] (en)<br>
     * [状態で抽出] (ja)<br>
     *
     * @return key[DialogCtrlButtonStateCheck]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlButtonStateCheck() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract by State";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlButtonStateCheck");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlButtonCountCheck]
     *
     * [Extract by the number of units.] (en)<br>
     * [件数で区切って抽出] (ja)<br>
     *
     * @return key[DialogCtrlButtonCountCheck]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlButtonCountCheck() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extract by the number of units.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlButtonCountCheck");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlGroupFilename]
     *
     * [Output Filename Option] (en)<br>
     * [出力ファイル名オプション] (ja)<br>
     *
     * @return key[DialogCtrlGroupFilename]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlGroupFilename() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Output Filename Option";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlGroupFilename");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogCtrlButtonIncludeDateCheck]
     *
     * [Include the date in the filename] (en)<br>
     * [ファイル名に年月日を含める] (ja)<br>
     *
     * @return key[DialogCtrlButtonIncludeDateCheck]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlButtonIncludeDateCheck() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Include the date in the filename";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlButtonIncludeDateCheck");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogMsg.001]
     *
     * [Please enter the integer number greater than 0 for unit count.] (en)<br>
     * [件数は 1 以上の数値を入力してください。] (ja)<br>
     *
     * @return key[DialogMsg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogMsg001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please enter the integer number greater than 0 for unit count.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogMsg.001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[DialogMsg.002]
     *
     * [Please enter the number for unit count.] (en)<br>
     * [件数に数値を入力してください。] (ja)<br>
     *
     * @return key[DialogMsg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogMsg002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please enter the number for unit count.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogMsg.002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreP001]
     *
     * [Planning the process items...] (en)<br>
     * [処理内容を計画中...] (ja)<br>
     *
     * @return key[CoreP001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Planning the process items...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreP003]
     *
     * [Process completed.\n{0}] (en)<br>
     * [処理を完了しました。\n{0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP003(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Process completed.\n{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreP011]
     *
     * [Processing the file [{0}]...] (en)<br>
     * [ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP011(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreP012]
     *
     * [Writing into the directory [{0}]...] (en)<br>
     * [ディレクトリー [{0}] に書き出し中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP012(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Writing into the directory [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreP101]
     *
     * [Processing the file [{0}] ({1,number}/{2,number})...] (en)<br>
     * [ファイル [{0}] ({1,number}/{2,number}) を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.math.BigDecimal型を与えてください。
     * @param arg2 置換文字列{2}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[CoreP101]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP101(final String arg0, final BigDecimal arg1, final BigDecimal arg2) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}] ({1,number}/{2,number})...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP101");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE011]
     *
     * [Exception occurred while reading the XLIFF file [{0}]: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の読み込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE011(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while reading the XLIFF file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE012]
     *
     * [Exception occurred while writing the XLIFF file [{0}]: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の書き込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE012(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while writing the XLIFF file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE021]
     *
     * [Input XLIFF file [{0}] could not be found.] (en)<br>
     * [入力 XLIFF ファイル [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE021]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE021(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input XLIFF file [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE021");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE022]
     *
     * [Input XLIFF file [{0}] is not a file.] (en)<br>
     * [入力 XLIFF ファイル [{0}] は、ファイルではありません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE022]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE022(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input XLIFF file [{0}] is not a file.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE022");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE023]
     *
     * [Unable to read the input XLIFF file [{0}].] (en)<br>
     * [入力 XLIFF ファイル [{0}] は、読み込めません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE023]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE023(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unable to read the input XLIFF file [{0}].";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE023");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE024]
     *
     * [Failed to create of the output XLIFF directory [{0}] while trying to do since it does not exist.] (en)<br>
     * [出力 XLIFF ディレクトリー [{0}] は存在しないので、新規に作成しようとしましたが失敗しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE024]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE024(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to create of the output XLIFF directory [{0}] while trying to do since it does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE024");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenExtractXliffFragmentMessages], key[CoreE025]
     *
     * [Output XLIFF directory [{0}] is not a directory.] (en)<br>
     * [出力 XLIFF ディレクトリー [{0}] は、ディレクトリーではありません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE025]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE025(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Output XLIFF directory [{0}] is not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE025");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
