/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.xliff.status;

import java.io.File;

import benten.ui.UiStatus;

/**
 * 状態をダイアログとハンドラーで共用するためのクラス。
 */
public class BentenMergeXliffStatus extends UiStatus {
    /**
     * フィールド: [fromDir]。
     */
    private File fFromDir;

    /**
     * フィールド: [toDir]。
     */
    private File fToDir;

    /**
     * フィールド [fromDir] の値を設定します。
     *
     * @param argFromDir フィールド[fromDir]に設定する値。
     */
    public void setFromDir(final File argFromDir) {
        fFromDir = argFromDir;
    }

    /**
     * フィールド [fromDir] の値を取得します。
     *
     * @return フィールド[fromDir]から取得した値。
     */
    public File getFromDir() {
        return fFromDir;
    }

    /**
     * フィールド [toDir] の値を設定します。
     *
     * @param argToDir フィールド[toDir]に設定する値。
     */
    public void setToDir(final File argToDir) {
        fToDir = argToDir;
    }

    /**
     * フィールド [toDir] の値を取得します。
     *
     * @return フィールド[toDir]から取得した値。
     */
    public File getToDir() {
        return fToDir;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.xliff.status.BentenMergeXliffStatus[");
        buf.append("fromDir=" + fFromDir);
        buf.append(",toDir=" + fToDir);
        buf.append("]");
        return buf.toString();
    }
}
