/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.ui.dialogs;

import org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

import benten.cat.tm.ui.CatTmUiPlugin;
import benten.twa.ui.dialogs.messages.AbstractTmWorkflowDialogMessages;
import benten.ui.UiPlugin;
import benten.ui.fields.TextField;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;

/**
 * TM 設定を使用するワークフローで使用するダイアログの基底クラス。
 *
 * <UL>
 * <LI>翻訳ワークフローで必要な OK ボタン押下時の処理や検証が抽象化されています。
 * <LI>完全一致訳適用や類似訳適用などで利用されます。
 * <UL>
 *
 * @author KASHIHARA Shinji
 */
public abstract class AbstractTmWorkflowDialog extends AbstractWorkflowDialog implements IPreferenceChangeListener {

	/**
	 * ワークフローで使用するダイアログの基底クラスのためのメッセージ。
	 */
	protected static final AbstractTmWorkflowDialogMessages fMsg = new AbstractTmWorkflowDialogMessages();

	/** TM エンジン */
	private TextField tmEngineText;

	/** TMX のロケーション */
	private TextField tmxLocationText;

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 * @param title タイトル
	 */
	public AbstractTmWorkflowDialog(final Shell parentShell, final IStructuredSelection selection, final String title) {
		super(parentShell, selection, title);
	}

	/**
	 * TM 設定エリアの作成。
	 * @param composite コンポジット。
	 */
	protected void createTmPreferenceArea(final Composite composite) {

		tmEngineText = new TextField(composite, fMsg.getDialogCtrlLabelTmEngine());
		tmEngineText.setEnabled(false);
		final Button tmPreferenceButton = new Button(composite, SWT.PUSH);
		tmPreferenceButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		tmPreferenceButton.setText(fMsg.getDialogCtrlButtonPreference());
		tmxLocationText = new TextField(composite, fMsg.getDialogCtrlLabelTmxLocation());
		tmxLocationText.setEnabled(false);
		new Label(composite, SWT.NONE);

		tmPreferenceButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				final String pageId = "benten.cat.tm.ui.preferencePage"; //$NON-NLS-1$
				final PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(UiPlugin.getShell(), pageId,
						new String[] { pageId }, null);
				dialog.open();
			}
		});
		preferenceChange(null);
		CatTmUiPlugin.getDefault().addPreferenceChangeListner(this);
	}

	/**
	 * {@inheritDoc}
	 */
	public void preferenceChange(final PreferenceChangeEvent event) {
		final IPreferenceStore store = BentenPreference.getStore();
		tmEngineText.setText(store.getString(Preference.TM_NAME.name()));
		if (store.getBoolean(Preference.USE_TMX_LOCATION.name())) {
			tmxLocationText.setText(store.getString(Preference.TMX_LOCATION.name()));
		} else {
			tmxLocationText.setText(fMsg.getDialogCtrlDefaultTmx());
		}
	}

	@Override
	public boolean close() {
		CatTmUiPlugin.getDefault().removePreferenceChangeListner(this);
		return super.close();
	}
}
