/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.fields;

import java.util.regex.Pattern;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Composite;

import benten.ui.dialogs.AbstractResourceSelectionDialog;
import benten.ui.dialogs.ResourceFolderSelectionDialog;

/**
 * フォルダーを選択するためのテキスト・フィールドです。
 *
 * <UL>
 * <LI>Eclipse のリソース・フォルダーを選択するためのフィールド・クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class ResourceFolderTextField extends ResourceFileTextField implements IFolderTextField {

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 * @param labelText ラベル・テキスト
	 */
	public ResourceFolderTextField(final Composite parent, final String labelText) {
		super(parent, labelText);
	}

	@Override
	protected AbstractResourceSelectionDialog createResourceSelectionDialog() {
		final IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
		final ResourceFolderSelectionDialog dialog = new ResourceFolderSelectionDialog(parent.getShell(), projects);
		return dialog;
	}

	@Override
	protected IResource getResource(final String relativePath) {
		final String[] segments = relativePath.split("/"); //$NON-NLS-1$
		final String projectName = segments[0];
		final IProject project = getProject(projectName);
		if (project == null) {
			return null;
		}
		if (segments.length == 1) {
			return project;
		}
		final String path = relativePath.replaceFirst(Pattern.quote(projectName) + "/", ""); //$NON-NLS-1$ //$NON-NLS-2$
		return project.getFolder(path);
	}
}
