/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoHtmlNormalize]̃NX
 */
package blanco.html.normalizer.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.html.normalizer.task.valueobject.BlancoHtmlNormalizeProcessInput;

/**
 * Apache Ant^XN [BlancoHtmlNormalize]̃NXB
 *
 * HTML𐳏퉻 Ant ^XNB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.html.normalizer.task]BlancoHtmlNormalizeBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancohtmlnormalize&quot; classname=&quot;blanco.html.normalizer.task.BlancoHtmlNormalizeTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoHtmlNormalizeTask extends Task {
    /**
     * HTML𐳏퉻 Ant ^XNB
     */
    protected BlancoHtmlNormalizeProcessInput fInput = new BlancoHtmlNormalizeProcessInput();

    /**
     * tB[h [sourcedir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldSourcedirProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * HTMLt@Ci[Ă̓fBNgB<br>
     *
     * @param arg Zbgl
     */
    public void setSourcedir(final String arg) {
        fInput.setSourcedir(arg);
        fIsFieldSourcedirProcessed = true;
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * HTMLt@Ci[Ă̓fBNgB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSourcedir() {
        return fInput.getSourcedir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * normalize ꂽHTMLt@Ci[o̓fBNgB<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * normalize ꂽHTMLt@Ci[o̓fBNgB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoHtmlNormalizeTask begin.");

        // ڔԍ[1]AAgr[g[sourcedir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldSourcedirProcessed == false) {
            throw new BuildException("K{Agr[g[sourcedir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[targetdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldTargetdirProcessed == false) {
            throw new BuildException("K{Agr[g[targetdir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- sourcedir:[" + getSourcedir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoHtmlNormalizeProcessC^tF[X blanco.html.normalizer.taskpbP[W BlancoHtmlNormalizeProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoHtmlNormalizeProcess proc = new BlancoHtmlNormalizeProcessImpl();
            if (proc.execute(fInput) != BlancoHtmlNormalizeBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
