/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2009 Alex Buloichik
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 **************************************************************************/

package blanco.omegat.util.mt.google;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Pane for display translation from Google Translate.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 */
	public abstract class AbstractMyGoogleTranslate{

	protected static String GT_URL = "http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&langpair=#sourceLang#|#targetLang#&q=";
    protected static String MARK_BEG = "{\"translatedText\":\"";
    protected static String MARK_END = "\"}";
    protected static Pattern RE_UNICODE = Pattern
            .compile("\\\\u([0-9A-Fa-f]{4})");
    protected static Pattern RE_HTML = Pattern.compile("&#([0-9]+);");

    public String translate(String string){
    	String result = null;
    	try {
    		result = translate(string, "en", "ja");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return result;
    }

    /**
     * Call google api and parse JSON result.
     * 
     * @param text
     *            text to traEnslate
     * @param from
     *            soEurce language
     * @param to
     *            target language
     * @return translation result
     * @throws Exception
     */
    public String translate(final String text, final String from,
            final String to) throws Exception {
        String url = getUrl(text, from, to);
        return translateByGoogle(url);
    }

	private static String getUrl(final String text, final String from, final String to)
			throws UnsupportedEncodingException {
		String trText = text.length() > 5000 ? text.substring(0, 4997) + "..."
                : text;
        String url = GT_URL.replace("#sourceLang#", from).replace(
                "#targetLang#", to)
                + URLEncoder.encode(trText, "UTF-8");
		return url;
	}

    private String translateByGoogle(String url) {
		StringBuffer page = new StringBuffer();
		try 
		{
			InputStream in = null;
			in = getInputStream(url);
			
		    byte[] b = new byte[4096];	
		    for (int n; (n = in.read(b)) != -1;) 
		    {
		        page.append(new String(b, 0, n, "UTF-8"));                      // NOI18N
		    }
		} 
		catch (Exception e) 
		{
		    e.printStackTrace();
		}

        String v = page.toString();
        while (true) {
            Matcher m = RE_UNICODE.matcher(v);
            if (!m.find()) {
                break;
            }
            String g = m.group();
            char c = (char) Integer.parseInt(m.group(1), 16);
            v = v.replace(g, Character.toString(c));
        }
        v = v.replace("&quot;", "&#34;");
        v = v.replace("&nbsp;", "&#160;");
        v = v.replace("&amp;", "&#38;");
        while (true) {
            Matcher m = RE_HTML.matcher(v);
            if (!m.find()) {
                break;
            }
            String g = m.group();
            char c = (char) Integer.parseInt(m.group(1));
            v = v.replace(g, Character.toString(c));
        }

        int beg = v.indexOf(MARK_BEG) + MARK_BEG.length();
        int end = v.indexOf(MARK_END, beg);
        String tr = v.substring(beg, end);
		return tr;
	}
    
    abstract protected InputStream getInputStream(String url);

}
