/*
 * このソースコードは blanco Frameworkによって自動生成されています。
 */
package benten.cat.build.stepcounter.io;

import java.io.BufferedWriter;
import java.io.IOException;

import benten.cat.build.stepcounter.record.StepCounterCsvRecord;

/**
 * ファイル定義[StepCounter]のライタクラス。
 *
 * このクラスはblancoCsvファイル定義書から自動生成されたライタクラスです。<br>
 * 　1.文字列長チェックには、デフォルトエンコーディングを利用します。<br>
 * 　2.クラスの利用した後は必ず close()を呼び出してください。<br>
 */
public class StepCounterCsvWriter {
    /**
     * ライタオブジェクト。
     *
     * CSV処理で関連づけられる、実際に出力を行うライタ。
     */
    protected BufferedWriter fWriter;

    /**
     * 現在処理中の行カウンタ。
     *
     * 現在処理を行っている行の位置。
     */
    protected long fLineCounter = 0;

    /**
     * CSVライタクラスのコンストラクタ。
     */
    public StepCounterCsvWriter() {
        init();
    }

    /**
     * CSVライタクラスのコンストラクタ。
     *
     * 与えられたライタと関連づけます。
     *
     * @param arg 関連づけるライタ。
     */
    public StepCounterCsvWriter(final BufferedWriter arg) {
        fWriter = arg;
        init();
    }

    /**
     * 初期化をおこないます。
     */
    protected void init() {
    }

    /**
     * CSVファイルのタイトル行を書き出します。
     *
     * タイトルはデリミタで区切られながらライタに出力され、最後に改行コードが付与されます。<br>
     *
     * @throws IOException 関連づけられたライタ出力の際に例外が発生した場合。
     */
    public void writeTitle() throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("[StepCounter] ライタが設定されていない状態でメソッド[writeTitle]が呼び出されました。これは許可されません。ライタをセットしてから呼びだしてください。");
        }

        fWriter.write("名前");
        fWriter.write(",タイプ");
        fWriter.write(",実行");
        fWriter.write(",空行");
        fWriter.write(",コメント");
        fWriter.write(",合計");
        fWriter.newLine();
    }

    /**
     * 与えられた一行を書き出します。
     *
     * データはデリミタで区切られながらライタに出力され、最後に改行コードが付与されます。
     *
     * @param record レコードオブジェクト。
     * @throws BlancoCsvIOException 与えられたレコード中の項目値が不正な場合など。
     * @throws IOException 関連づけられたライタ出力の際に例外が発生した場合。
     */
    public void writeRecord(final StepCounterCsvRecord record) throws BlancoCsvIOException, IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("[StepCounter] ライタが設定されていない状態でメソッド[writeRecord]が呼び出されました。これは許可されません。ライタをセットしてから呼びだしてください。");
        }

        String writeToken = null;

        // 項目名[name/名前]
        // 任意項目で文字列の項目に nullまたは長さ0の文字列が与えられた場合には、いずれも値が入っていないものとみなします。
        // この場合には長さチェックは行いません。
        writeToken = record.getName() == null ? "" : record.getName();
        if (writeToken.length() > 0) {
        }
        if (writeToken.indexOf(",") >= 0) {
            throw new BlancoCsvIOException("出力" + (fLineCounter + 1) + "行目 1項目目。項目名[name/名前]の処理中においてデータ中[" + writeToken + "]に項目のデリミタ[,]が含まれることを検知しました。");
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // 項目名[type/タイプ]
        // 任意項目で文字列の項目に nullまたは長さ0の文字列が与えられた場合には、いずれも値が入っていないものとみなします。
        // この場合には長さチェックは行いません。
        writeToken = record.getType() == null ? "" : record.getType();
        if (writeToken.length() > 0) {
        }
        if (writeToken.indexOf(",") >= 0) {
            throw new BlancoCsvIOException("出力" + (fLineCounter + 1) + "行目 2項目目。項目名[type/タイプ]の処理中においてデータ中[" + writeToken + "]に項目のデリミタ[,]が含まれることを検知しました。");
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // 項目名[loc/実行]
        if (record.getLoc() == null) {
            writeToken = "";
        } else {
            writeToken = String.valueOf(record.getLoc());
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // 項目名[blanc/空行]
        if (record.getBlanc() == null) {
            writeToken = "";
        } else {
            writeToken = String.valueOf(record.getBlanc());
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // 項目名[comment/コメント]
        if (record.getComment() == null) {
            writeToken = "";
        } else {
            writeToken = String.valueOf(record.getComment());
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // 項目名[total/合計]
        if (record.getTotal() == null) {
            writeToken = "";
        } else {
            writeToken = String.valueOf(record.getTotal());
        }
        fWriter.write(writeToken);

        // 最後に改行コードが付与されます。
        fWriter.newLine();
        fLineCounter++;
    }

    /**
     * CSV処理で関連づけられるライタを返します。
     *
     * @return CSV処理で関連づけられるライタ。
     */
    public BufferedWriter getWriter() {
        return fWriter;
    }

    /**
     * CSV処理で関連づけられるライタを設定します。
     *
     * @param argWriter CSV処理で関連づけられるライタ。
     */
    public void setWriter(final BufferedWriter argWriter) {
        fWriter = argWriter;
    }

    /**
     * 現在処理中の行カウンタを返します。
     *
     * @return 現在処理中の行カウンタ。
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * このライタをフラッシュします。
     *
     * 関連づけられたライタに対してもflush()を呼び出します。
     *
     * @throws IOException 関連づけられたライタのflush()に失敗した場合。
     */
    public void flush() throws IOException {
        if (fWriter != null) {
            fWriter.flush();
        }
    }

    /**
     * このライタを閉じます。
     *
     * 関連づけられたライタに対してもclose()を呼び出します。
     *
     * @throws IOException 関連づけられたライタのclose()に失敗した場合。
     */
    public void close() throws IOException {
        if (fWriter != null) {
            fWriter.close();
        }
    }
}
