/*
 * このソースコードは blanco Frameworkによって自動生成されています。
 */
package benten.cat.build.stepcounter.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import benten.cat.build.stepcounter.record.StepCounterSummaryCsvRecord;

/**
 * ファイル定義[StepCounterSummary]のリーダクラス。
 *
 * このクラスはblancoCsvファイル定義書から自動生成されたリーダクラスです。<br>
 * 　1.文字列長チェックには、デフォルトエンコーディングを利用します。<br>
 * 　2.クラスの利用した後は必ず close()を呼び出してください。<br>
 */
public class StepCounterSummaryCsvReader {
    /**
     * リーダオブジェクト
     *
     * CSV処理で関連づけられる、実際に入力を行うリーダ。
     */
    protected BufferedReader fReader;

    /**
     * 現在処理中の行カウンタ。
     *
     * 現在処理を行っている行の位置。
     */
    protected long fLineCounter = 0;

    /**
     * 現在処理中の行データ。
     */
    protected String fLine;

    /**
     * 現在処理中の行のためのリーダ。
     */
    protected StringReader fLineReader;

    /**
     * CSVリーダクラスのコンストラクタ。
     */
    public StepCounterSummaryCsvReader() {
        init();
    }

    /**
     * CSVリーダクラスのコンストラクタ。
     *
     * 与えられたリーダを関連づけます。
     *
     * @param arg 関連づけるリーダ。
     */
    public StepCounterSummaryCsvReader(final BufferedReader arg) {
        fReader = arg;
        init();
    }

    /**
     * 初期化をおこないます。
     */
    protected void init() {
    }

    /**
     * 関連づけられたリーダから、次の一行を読み込みます。
     *
     * @return 行オブジェクトを返します。リーダが終端に達し、もはや行が無い場合には nullを返します。
     * @throws BlancoCsvIOException 入力データが不正な場合など。
     * @throws IOException 関連づけられたリーダで例外が発生した場合。
     */
    public StepCounterSummaryCsvRecord readRecord() throws BlancoCsvIOException, IOException {
        if (fReader == null) {
            throw new IllegalArgumentException("[StepCounterSummary] リーダが設定されていない状態でメソッド[readRecord]が呼び出されました。これは許可されません。リーダをセットしてから呼びだしてください。");
        }

        fLine = fReader.readLine();
        if (fLine == null) {
            // ファイルの終端に到達しました。
            return null;
        }
        fLineCounter++;
        final StepCounterSummaryCsvRecord record = new StepCounterSummaryCsvRecord();
        fLineReader = new StringReader(fLine);
        String tokenString = null;

        // 項目名[pluginName/プラグイン名]
        tokenString = readToken(',', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 1項目目。項目名[pluginName/プラグイン名]の処理中において不正な終端を検知しました。");
        }
        // 必須項目。
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 1項目目。項目名[pluginName/プラグイン名]の処理中において必須項目に値が入っていないことを検知しました。");
        }
        record.setPluginName(tokenString);

        // 項目名[src/ソース行数]
        tokenString = readToken(',', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 2項目目。項目名[src/ソース行数]の処理中において不正な終端を検知しました。");
        }
        // 必須項目。
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 2項目目。項目名[src/ソース行数]の処理中において必須項目に値が入っていないことを検知しました。");
        }
        try {
            record.setSrc(Integer.parseInt(tokenString));
        } catch (NumberFormatException ex) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 2項目目。項目名[src/ソース行数]の処理中において数値(int)としては解析できない文字[" + tokenString + "]を検知しました。:" + ex.toString(), ex);
        }

        // 項目名[blanco/blanco行数]
        tokenString = readToken(',', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 3項目目。項目名[blanco/blanco行数]の処理中において不正な終端を検知しました。");
        }
        // 必須項目。
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 3項目目。項目名[blanco/blanco行数]の処理中において必須項目に値が入っていないことを検知しました。");
        }
        try {
            record.setBlanco(Integer.parseInt(tokenString));
        } catch (NumberFormatException ex) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 3項目目。項目名[blanco/blanco行数]の処理中において数値(int)としては解析できない文字[" + tokenString + "]を検知しました。:" + ex.toString(), ex);
        }

        // 項目名[xml/xml行数]
        tokenString = readToken(',', true);
        if (tokenString == null) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 4項目目。項目名[xml/xml行数]の処理中において不正な終端を検知しました。");
        }
        // 必須項目。
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 4項目目。項目名[xml/xml行数]の処理中において必須項目に値が入っていないことを検知しました。");
        }
        try {
            record.setXml(Integer.parseInt(tokenString));
        } catch (NumberFormatException ex) {
            throw new BlancoCsvIOException("入力" + fLineCounter + "行目 4項目目。項目名[xml/xml行数]の処理中において数値(int)としては解析できない文字[" + tokenString + "]を検知しました。:" + ex.toString(), ex);
        }
        return record;
    }

    /**
     * CSV処理で関連づけられるリーダを返します。
     *
     * @return CSV処理で関連づけられるリーダ。
     */
    public BufferedReader getReader() {
        return fReader;
    }

    /**
     * CSV処理で関連づけられるリーダを設定します。
     *
     * @param argReader CSV処理で関連づけられるリーダ。
     */
    public void setReader(final BufferedReader argReader) {
        fReader = argReader;
    }

    /**
     * 現在処理中の行カウンタを返します。
     *
     * @return 現在処理中の行カウンタ。
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * このリーダを閉じます。
     *
     * 関連づけられたリーダに対してもclose()を呼び出します。
     *
     * @throws IOException 関連づけられたリーダのclose()に失敗した場合。
     */
    public void close() throws IOException {
        if (fReader != null) {
            fReader.close();
        }
    }

    /**
     * 関連づけられたReaderから 与えられたデリミタを使ってトークンを取り出します。
     *
     * @param delimiter デリミタ
     * @param isEndOfLine 行の終端であるのかどうかフラグ
     * @return 取り出されたトークン。もはやリーダが空の場合にはnullを返します。
     * @throws BlancoCsvIOException 項目数が足りないなど与えられた文字列に関する例外が発生した場合。
     * @throws IOException 入出力例外が発生した場合。
     */
    protected String readToken(final char delimiter, final boolean isEndOfLine) throws BlancoCsvIOException, IOException {
        final StringBuffer buffer = new StringBuffer();
        for (;;) {
            final int iRead = fLineReader.read();
            if (iRead < 0) {
                // 終端に到達。
                if (isEndOfLine == false) {
                    throw new BlancoCsvIOException("行の終端でないのにも関わらずデリミタが現れずに行が終了してしまいました。");
                }
                break;
            }
            if (iRead == delimiter) {
                if (isEndOfLine) {
                    throw new BlancoCsvIOException("行の終端であるべきにも関わらずデリミタが現れました。");
                }
                break;
            } else {
                buffer.append((char) iRead);
            }
        }
        return buffer.toString();
    }

    /**
     * 関連づけられたReaderから ダブルクオート処理付きで 与えられたデリミタを使ってトークンを取り出します。
     *
     * @param delimiter デリミタ
     * @param isEndOfLine 行の終端であるのかどうかフラグ
     * @return 取り出されたトークン。もはやリーダが空の場合にはnullを返します。
     * @throws BlancoCsvIOException ダブルクオートの不一致など与えられた文字列に関する例外が発生した場合。
     * @throws IOException 入出力例外が発生した場合。
     */
    protected String readTokenWithQuote(final char delimiter, final boolean isEndOfLine) throws BlancoCsvIOException, IOException {
        final StringBuffer buffer = new StringBuffer();
        boolean isStringStarted = false;
        boolean isStringEnded = false;
        for (;;) {
            int iRead = fLineReader.read();
            if (iRead < 0) {
                // 終端に到達。
                if (isStringStarted && isStringEnded == false) {
                    // 改行を出力。
                    buffer.append('\n');
                    // ダブルクオート内。
                    fLine = fReader.readLine();
                    if (fLine == null) {
                        // ダブルクオート内であるのにもかかわらずファイルの終端に到達しました。
                        break;
                    } else {
                        fLineReader = new StringReader(fLine);
                        continue;
                    }
                } else if (isEndOfLine == false) {
                    throw new BlancoCsvIOException("行の終端でないのにも関わらずデリミタが現れずに行が終了してしまいました。");
                }
                break;
            }
            if (isStringStarted == false) {
                if (iRead != '"') {
                    throw new BlancoCsvIOException("ダブルクオート無しで文字列が開始されました。");
                }
                // ダブルクオーテーションは読み飛ばします。
                isStringStarted = true;
            } else if (isStringEnded) {
                if (iRead == delimiter) {
                    // 文字列終端に到達しました。
                    if (isEndOfLine) {
                        throw new BlancoCsvIOException("行の終端であるべきにも関わらずデリミタが現れました。");
                    }
                    break;
                }
                throw new BlancoCsvIOException("ダブルクオートによる文字列終了より後に文字列が与えられました。");
            } else {
                // 通常の文字列エリア
                if (iRead == '"') {
                    // ダブルクオートが重ねられたものでないかどうかチェックします。
                    fLineReader.mark(1);
                    if (fLineReader.read() == '"') {
                        // エスケープされたダブルクオート
                        // 2つでひとつなので、ひとつは読み捨てます。
                        buffer.append((char) iRead);
                    } else {
                        // ダブルクオートによるエスケープではありませんでした。
                        // これは終端を意味しています。
                        fLineReader.reset();
                        isStringEnded = true;
                    }
                } else {
                    buffer.append((char) iRead);
                }
            }
        }
        if (isStringStarted == false) {
            throw new BlancoCsvIOException("ダブルクオートが必要な文字列であるのにダブルクオートによる開始が現れませんでした。");
        }
        if (isStringEnded == false) {
            throw new BlancoCsvIOException("ダブルクオートが必要な文字列であるのにダブルクオートによる終了が現れませんでした。");
        }
        return buffer.toString();
    }
}
