/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle.resourcebundle;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

/**
 * BlancoResourceBundle CSP (Collection of Small Programs) ̃\[Xoh`łB
 *
 * \[Xoh`: [BlancoResourceBundle]B<BR>
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoResourceBundleResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoResourceBundleResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoResourceBundle]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoResourceBundleResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/resourcebundle/resourcebundle/BlancoResourceBundle");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
    }

    /**
     * BlancoResourceBundleResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoResourceBundle]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoResourceBundleResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/resourcebundle/resourcebundle/BlancoResourceBundle", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
    }

    /**
     * BlancoResourceBundleResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoResourceBundle]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoResourceBundleResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/resourcebundle/resourcebundle/BlancoResourceBundle", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoResourceBundle], key[METAFILE_DISPLAYNAME]
     *
     * [\[Xoh`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[META2XML.ELEMENT_COMMON]
     *
     * [blancoresourcebundle-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoresourcebundle-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[META2XML.ELEMENT_COMMON]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[META2XML.ELEMENT_LIST]
     *
     * [blancoresourcebundle-resourceList] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoresourcebundle-resourceList";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[META2XML.ELEMENT_LIST]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[KEY_PREFIX]
     *
     * [] (ja)<br>
     *
     * @return key[KEY_PREFIX]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getKeyPrefix() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("KEY_PREFIX");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[KEY_PREFIX]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[GENERATE_BUNDLE_SOURCE]
     *
     * [true] (ja)<br>
     *
     * @return key[GENERATE_BUNDLE_SOURCE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getGenerateBundleSource() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("GENERATE_BUNDLE_SOURCE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[GENERATE_BUNDLE_SOURCE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[GENERATE_CONSTANTS_SOURCE]
     *
     * [false] (ja)<br>
     *
     * @return key[GENERATE_CONSTANTS_SOURCE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getGenerateConstantsSource() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("GENERATE_CONSTANTS_SOURCE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[GENERATE_CONSTANTS_SOURCE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC011]
     *
     * [\[Xoh`: [{0}]B&lt;BR&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC011]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc011(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`: [{0}]B<BR>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC011");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC011]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC012]
     *
     * [̃NX̓\[Xoh`玩ꂽ\[XohNXłB&lt;BR&gt;] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC012]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc012() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC012");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC012]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC013]
     *
     * [m̃P[&lt;BR&gt;] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC013]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc013() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "m̃P[<BR>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC013");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC013]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC014]
     *
     * [\[XohIuWFNgB] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC014]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc014() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[XohIuWFNgB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC014");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC014]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC015]
     *
     * [IɎۂɓ͂s\[XohL܂B] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC015]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc015() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "IɎۂɓ͂s\[XohL܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC015");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC015]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC021]
     *
     * [{0}NX̃RXgN^B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC021]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc021(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}NX̃RXgN^B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC021");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC021]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC022]
     *
     * [ꖼ[{0}]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC022]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc022(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC022");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC022]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC023]
     *
     * [ꖼ[{0}]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC023]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc023(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC023");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC023]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC031]
     *
     * [{0}NX̃RXgN^B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC031]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc031(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}NX̃RXgN^B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC031");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC031]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC032]
     *
     * [ꖼ[{0}]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC032]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc032(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC032");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC032]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC033]
     *
     * [P[̎w] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC033]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc033() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "P[̎w";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC033");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC033]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC034]
     *
     * [ꖼ[{0}]AP[[&quot; + locale.toString() + &quot;]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC034]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc034(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]AP[[\" + locale.toString() + \"]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC034");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC034]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC041]
     *
     * [{0}NX̃RXgN^B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC041]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc041(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}NX̃RXgN^B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC041");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC041]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC042]
     *
     * [ꖼ[{0}]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC042]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc042(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC042");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC042]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC043]
     *
     * [P[̎w] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC043]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc043() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "P[̎w";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC043");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC043]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC044]
     *
     * [NX[_̎w] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC044]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc044() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX[_̎w";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC044");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC044]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC045]
     *
     * [ꖼ[{0}]AP[[&quot; + locale.toString() + &quot;]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC045]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc045(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]AP[[\" + locale.toString() + \"]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC045");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC045]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC051]
     *
     * [wȂ] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC051]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc051() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "wȂ";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC051");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC051]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC101]
     *
     * [u'{'{0,number}'}'ulB{1}^^ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.math.BigDecimal^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC101]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc101(final BigDecimal arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "u'{'{0,number}'}'ulB{1}^^ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC101");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC101]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC102]
     *
     * [key[{0}]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC102]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc102(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "key[{0}]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC102");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC102]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC103]
     *
     * [TODO: : P[({0})͐ݒ肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC103]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc103(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "TODO: : P[({0})͐ݒ肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC103");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC103]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC104]
     *
     * [lƂĒ`̒l𗘗p܂B] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC104]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc104() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "lƂĒ`̒l𗘗p܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC104");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC104]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC105]
     *
     * [ꖼ[{0}]AL[[{1}]̒`擾ł܂łB`̒l𗘗pďs܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[EXPANDRESOURCE.SRC105]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc105(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}]AL[[{1}]̒`擾ł܂łB`̒l𗘗pďs܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC105");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC105]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC106]
     *
     * [^ꂽɒuu܂B] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC106]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc106() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^ꂽɒuu܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC106");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC106]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoResourceBundle], key[EXPANDRESOURCE.SRC107]
     *
     * [u͂ЂƂ܂B] (ja)<br>
     *
     * @return key[EXPANDRESOURCE.SRC107]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpandresourceSrc107() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "u͂ЂƂ܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDRESOURCE.SRC107");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoResourceBundle]AL[[EXPANDRESOURCE.SRC107]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.resourcebundle.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
