/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.tmx;

import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;

/**
 * TMX𑀍삷邽߂̃[eBeB[B
 * 
 * @author IGA Tosiki
 */
public class BlancoTmxUtil {
    /**
     * ^ꂽ tu w肵 lang  tuv 擾܂B
     * 
     * @param tu
     *            tu IuWFNgB
     * @param lang
     *            B
     * @return ꂽ tuvBłȂꍇɂ nullB
     */
    public static BlancoTmxTuv getTuvByLang(final BlancoTmxTu tu,
            final String lang) {
        for (BlancoTmxTuv tuv : tu.getTuvList()) {
            if (checkLangEqual(tuv, lang)) {
                // ŏɌ̂߂܂B
                return tuv;
            }
        }

        // łB
        return null;
    }

    /**
     * tuv w肵 lang ƈv邩ǂ𔻒肵܂B
     * 
     * x܂ɔf܂B
     * 
     * @param tuv
     * @param lang
     * @return
     */
    public static boolean checkLangEqual(final BlancoTmxTuv tuv,
            final String lang) {
        if (tuv.getLang() == null) {
            throw new IllegalArgumentException(
                    "tuv ɂ K lang w肳ȂĂ͂Ȃ܂B:" + tuv.toString());
        }

        if (tuv.getLang().toUpperCase().equals(lang.toUpperCase())
                || tuv.getLang().toUpperCase().startsWith(
                        lang.toUpperCase() + "-")) {
            return true;
        }

        return false;
    }
}
