/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoXliffUtilExtractState]̃NX
 */
package blanco.xliff.util.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilExtractStateProcessInput;

/**
 * Apache Ant^XN [BlancoXliffUtilExtractState]̃NXB
 *
 * [XLIFFΉc[] w state  trans-unit 𒊏o܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.xliff.util.task]BlancoXliffUtilExtractStateBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoxliffutilextractstate&quot; classname=&quot;blanco.xliff.util.task.BlancoXliffUtilExtractStateTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoXliffUtilExtractStateTask extends Task {
    /**
     * [XLIFFΉc[] w state  trans-unit 𒊏o܂B
     */
    protected BlancoXliffUtilExtractStateProcessInput fInput = new BlancoXliffUtilExtractStateProcessInput();

    /**
     * tB[h [targetfile] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetfileProcessed = false;

    /**
     * tB[h [xliffdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldXliffdirProcessed = false;

    /**
     * tB[h [state] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldStateProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[targetfile]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * o͑Ώۂ XLIFF (*.xlf) t@C<br>
     *
     * @param arg Zbgl
     */
    public void setTargetfile(final String arg) {
        fInput.setTargetfile(arg);
        fIsFieldTargetfileProcessed = true;
    }

    /**
     * Ant^XN[targetfile]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * o͑Ώۂ XLIFF (*.xlf) t@C<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetfile() {
        return fInput.getTargetfile();
    }

    /**
     * Ant^XN[xliffdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * ͑Ώۂ XLIFF (*.xlf) t@C܂܂fBNgB<br>
     *
     * @param arg Zbgl
     */
    public void setXliffdir(final String arg) {
        fInput.setXliffdir(arg);
        fIsFieldXliffdirProcessed = true;
    }

    /**
     * Ant^XN[xliffdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * ͑Ώۂ XLIFF (*.xlf) t@C܂܂fBNgB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getXliffdir() {
        return fInput.getXliffdir();
    }

    /**
     * Ant^XN[state]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * trans-unit  state lB<br>
     *
     * @param arg Zbgl
     */
    public void setState(final String arg) {
        fInput.setState(arg);
        fIsFieldStateProcessed = true;
    }

    /**
     * Ant^XN[state]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * trans-unit  state lB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getState() {
        return fInput.getState();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoXliffUtilExtractStateTask begin.");

        // ڔԍ[1]AAgr[g[targetfile]͕K{͂łB̓`FbNs܂B
        if (fIsFieldTargetfileProcessed == false) {
            throw new BuildException("K{Agr[g[targetfile]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[xliffdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldXliffdirProcessed == false) {
            throw new BuildException("K{Agr[g[xliffdir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[3]AAgr[g[state]͕K{͂łB̓`FbNs܂B
        if (fIsFieldStateProcessed == false) {
            throw new BuildException("K{Agr[g[state]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- targetfile:[" + getTargetfile() + "]");
            System.out.println("- xliffdir:[" + getXliffdir() + "]");
            System.out.println("- state:[" + getState() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoXliffUtilExtractStateProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilExtractStateProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoXliffUtilExtractStateProcess proc = new BlancoXliffUtilExtractStateProcessImpl();
            if (proc.execute(fInput) != BlancoXliffUtilExtractStateBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
