/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.xliff.util.task;

import java.io.IOException;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilSplitProcessInput;

/**
 * ob`NX [BlancoXliffUtilSplitBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.xliff.util.task.BlancoXliffUtilSplitBatchProcess -help
 * </code>
 */
public class BlancoXliffUtilSplitBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoXliffUtilSplitBatchProcess batchProcess = new BlancoXliffUtilSplitBatchProcess();

        // ob`̈B
        final BlancoXliffUtilSplitProcessInput input = new BlancoXliffUtilSplitProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldTargetdirProcessed = false;
        boolean isFieldSourcefileProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
                isFieldTargetdirProcessed = true;
            } else if (arg.startsWith("-sourcefile=")) {
                input.setSourcefile(arg.substring(12));
                isFieldSourcefileProcessed = true;
            } else if (arg.startsWith("-count=")) {
                try {
                    input.setCount(Integer.parseInt(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoXliffUtilSplitBatchProcess: JnsB̓p[^[input]̃tB[h[count]𐔒l(int)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoXliffUtilSplitBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldTargetdirProcessed == false) {
            System.out.println("BlancoXliffUtilSplitBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldSourcefileProcessed == false) {
            System.out.println("BlancoXliffUtilSplitBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcefile]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoXliffUtilSplitProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoXliffUtilSplitProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilSplitProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoXliffUtilSplitProcess process = new BlancoXliffUtilSplitProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoXliffUtilSplitProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoXliffUtilSplitBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoXliffUtilSplitBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoXliffUtilSplitBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoXliffUtilSplitBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoXliffUtilSplitBatchProcess: Usage:");
        System.out.println("  java blanco.xliff.util.task.BlancoXliffUtilSplitBatchProcess -verbose=l1 -targetdir=l2 -sourcefile=l3 -count=l4");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -targetdir");
        System.out.println("      [XLIFF (*.xlf) t@Co͂fBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -sourcefile");
        System.out.println("      [͑Ώۂ XLIFF (*.xlf) t@CB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -count");
        System.out.println("      [ۂ trans-unit ̌B]");
        System.out.println("      ^[l(int)]");
        System.out.println("      ftHgl[50]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoXliffUtilSplitProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getTargetdir() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilSplitBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
        }
        if (input.getSourcefile() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilSplitBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcefile]ɒlݒ肳Ă܂B");
        }
    }
}
