/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoXliffUtilStatistics]̃NX
 */
package blanco.xliff.util.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilStatisticsProcessInput;

/**
 * Apache Ant^XN [BlancoXliffUtilStatistics]̃NXB
 *
 * [XLIFFΉc[] XLIFFt@C̓v\܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.xliff.util.task]BlancoXliffUtilStatisticsBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoxliffutilstatistics&quot; classname=&quot;blanco.xliff.util.task.BlancoXliffUtilStatisticsTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoXliffUtilStatisticsTask extends Task {
    /**
     * [XLIFFΉc[] XLIFFt@C̓v\܂B
     */
    protected BlancoXliffUtilStatisticsProcessInput fInput = new BlancoXliffUtilStatisticsProcessInput();

    /**
     * tB[h [xliffdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldXliffdirProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[xliffdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * XLIFFt@Ci[Ă̓[gEtH_w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setXliffdir(final String arg) {
        fInput.setXliffdir(arg);
        fIsFieldXliffdirProcessed = true;
    }

    /**
     * Ant^XN[xliffdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * XLIFFt@Ci[Ă̓[gEtH_w肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getXliffdir() {
        return fInput.getXliffdir();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoXliffUtilStatisticsTask begin.");

        // ڔԍ[1]AAgr[g[xliffdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldXliffdirProcessed == false) {
            throw new BuildException("K{Agr[g[xliffdir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- xliffdir:[" + getXliffdir() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoXliffUtilStatisticsProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilStatisticsProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoXliffUtilStatisticsProcess proc = new BlancoXliffUtilStatisticsProcessImpl();
            if (proc.execute(fInput) != BlancoXliffUtilStatisticsBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
