/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * blanco Frameworkɂt@C֘Ã[eBeBW߂NXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoFileUtil {
    /**
     * fobO[hœ삷邩ǂ̃tOB
     */
    private static final boolean IS_DEUBG = false;

    /**
     * ^ꂽ̓t@Co̓t@CւƃRs[܂B
     * 
     * ̓t@C݂ȂꍇȂǂɂ͗O܂B
     * 
     * @param fileInput
     *            ̓t@CBnull͗^ȂłB
     * @param fileOutput
     *            o̓t@CBnull͗^ȂłB
     * @throws IOException
     *             o͗OꍇB
     */
    public static final void copy(final File fileInput, final File fileOutput)
            throws IOException {
        if (IS_DEUBG) {
            System.out.println("BlancoFileUtil.copy("
                    + fileInput.getAbsolutePath() + ", "
                    + fileOutput.getAbsolutePath() + ")");
        }
        if (fileInput == null) {
            throw new IllegalArgumentException("̓t@Cnull^܂B");
        }
        if (fileOutput == null) {
            throw new IllegalArgumentException("o̓t@Cnull^܂B");
        }
        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileInput.getAbsolutePath() + "]܂B");
        }
        if (fileInput.isFile() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileInput.getAbsolutePath() + "]ɃfBNg^邱Ƃ͂ł܂B");
        }
        if (fileOutput.exists()) {
            if (fileOutput.isFile() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileInput.getAbsolutePath() + "]ɃfBNg^邱Ƃ͂ł܂B");
            }
            if (fileOutput.canWrite() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileInput.getAbsolutePath()
                        + "]݂ɁA݂sƂł܂B");
            }
        }

        final File fileTargetParent = fileOutput.getParentFile();
        if (fileTargetParent.exists() == false) {
            // ݂Ȃꍇɂ͍쐬܂B
            if (fileTargetParent.mkdirs() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileInput.getAbsolutePath() + "]̐etH_["
                        + fileTargetParent.getAbsolutePath()
                        + "]݂Ȃ̂ō쐬悤Ƃ܂쐬Ɏs܂B");
            }
        }

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileInput));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    fileOutput));

            // Xg[̃Rs[s܂B
            BlancoStreamUtil.copy(inStream, outStream);

            outStream.flush();
        } finally {
            try {
                // Xg[JĂꍇɂ͊mɃN[Y܂B
                if (inStream != null) {
                    inStream.close();
                }
            } finally {
                // Xg[JĂꍇɂ͊mɃN[Y܂B
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }

    /**
     * ^ꂽ̓Xg[o̓Xg[ւƃRs[܂B
     * 
     * ̃\bh̓ł̓tbV͍s܂BKvɉČĂяo\bhɂ flush()ĂB<br>
     * Iɂ ʃNX̃Xg[Rs[Ăяo܂B
     * 
     * @deprecated ̃\bh̑ BlancoStreamUtil.copy\bhĂяoƂ߂܂B
     * @param inStream
     *            ̓Xg[B
     * @param outStream
     *            o̓Xg[B
     * @throws IOException
     *             o͗OꍇB
     */
    public static final void copy(final InputStream inStream,
            final OutputStream outStream) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException(
                    "BlancoFileUtil.copy\bh̓̓Xg[p[^null^܂BnullȊO̒lw肵ĂB");
        }
        if (outStream == null) {
            throw new IllegalArgumentException(
                    "BlancoFileUtil.copy\bh̏o̓Xg[p[^null^܂BnullȊO̒lw肵ĂB");
        }

        BlancoStreamUtil.copy(inStream, outStream);
    }

    /**
     * t@Cǂݍ݁AbytezւƓWJ܂B
     * 
     * @param inputFile
     *            ̓t@CB
     * @return bytez񉻂ꂽt@C̓eB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             t@C݂ȂȂǂ̏ꍇB
     */
    public static final byte[] file2Bytes(final File inputFile)
            throws IOException, IllegalArgumentException {
        if (inputFile == null) {
            throw new IllegalArgumentException(
                    "file2Bytes()\bhɓ̓p[^Ƃnull^܂B");
        }
        if (inputFile.exists() == false) {
            throw new IllegalArgumentException(
                    "file2Bytes()\bhɓ̓p[^Ƃė^ꂽt@C݂͑܂B");
        }
        if (inputFile.canRead() == false) {
            throw new IllegalArgumentException(
                    "file2Bytes()\bhɓ̓p[^Ƃė^ꂽt@C͓ǂݍނƂł܂B");
        }
        if (inputFile.isDirectory()) {
            throw new IllegalArgumentException(
                    "file2Bytes()\bhɓ̓p[^ƂăfBNg^܂BfBNg͏ł܂");
        }

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(inputFile), BlancoStreamUtil.BUF_SIZE);
        try {
            BlancoStreamUtil.copy(inStream, outStream);
            outStream.flush();
            return outStream.toByteArray();
        } finally {
            inStream.close();
            outStream.close();
        }
    }

    /**
     * ^ꂽoCgzA^ꂽt@Cɏo͂܂B
     * 
     * @param inputBytes
     *            ͂ƂȂoCgzB
     * @param outputFile
     *            o͂ƂȂt@CB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             t@Cnull^ꂽȂǂ̏ꍇB
     */
    public static final void bytes2File(final byte[] inputBytes,
            final File outputFile) throws IOException, IllegalArgumentException {
        if (inputBytes == null) {
            throw new IllegalArgumentException(
                    "bytes2File()\bhɓ̓p[^̓̓oCgzƂnull^܂B");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(
                    "bytes2File()\bhɓ̓p[^̏o̓t@CƂnull^܂B");
        }
        if (outputFile.exists()) {
            if (outputFile.isDirectory()) {
                throw new IllegalArgumentException(
                        "bytes2File()\bhɓ̓p[^Ƃďo͐t@CɃfBNg^܂BfBNg͏ł܂");
            }
            if (outputFile.canWrite() == false) {
                throw new IllegalArgumentException(
                        "bytes2File()\bhɓ̓p[^Ƃė^ꂽt@C݂͑ɏ݂ł܂B");
            }
        } else {
            if (outputFile.createNewFile() == false) {
                throw new IllegalArgumentException(
                        "bytes2File()\bhɓ̓p[^Ƃďo͐t@C͐邱Ƃł܂B");
            }
        }

        final ByteArrayInputStream inStream = new ByteArrayInputStream(
                inputBytes);
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream(outputFile), BlancoStreamUtil.BUF_SIZE);
        try {
            BlancoStreamUtil.copy(inStream, outStream);
            outStream.flush();
        } finally {
            outStream.close();
            inStream.close();
        }
    }

    /**
     * KvɉāAoCgzt@Cɏo͂܂B
     * 
     * @param inputBytes
     *            ̓oCgzB
     * @param outputFile
     *            o͐t@CB
     * @return 0:쐬XVȂȂB1:t@CVKɍ쐬B2:t@CXVB
     * @throws IOException
     *             o͗OꍇB
     */
    public static final int bytes2FileIfNecessary(final byte[] inputBytes,
            final File outputFile) throws IOException {

        byte[] originalFileImage = null;
        if (outputFile.exists()) {
            // IWĩt@CC[W擾Ă܂B
            originalFileImage = file2Bytes(outputFile);
        }

        if (originalFileImage == null) {
            // L킳VK݁B
            bytes2File(inputBytes, outputFile);
            return 1;
        } else {
            if (BlancoByteUtil.compare(originalFileImage, inputBytes) == 0) {
                // ޕKvȂB
                return 0;
            } else {
                // XV݁B
                bytes2File(inputBytes, outputFile);
                return 2;
            }
        }
    }

    /**
     * s擾܂B
     * 
     * @return sBWindows Ȃ \n
     */
    public static final String getNewLine() {
        return System.getProperty("line.separator");
    }
}
