/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;

import benten.cat.glossary.core.BentenGlossarySearchResult;
import benten.cat.glossary.ui.views.GlossaryView;
import benten.ui.actions.AbstractCopyAction;

/**
 * 用語集ターゲット・コピー・アクション。
 *
 * <UL>
 * <LI>選択された用語集検索結果からターゲットを取得し、クリップボードへコピーするアクション・クラスです。
 * </UL>
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public class CopyGlossaryTargetAction extends AbstractCopyAction {

	/**
	 * コンストラクター。
	 * @param view ビュー
	 * @param text テキスト
	 */
	public CopyGlossaryTargetAction(final GlossaryView view, final String text) {
		super(view, text);
	}

	@Override
	protected String asText(final IStructuredSelection selection) {
		final BentenGlossarySearchResult entry = (BentenGlossarySearchResult) selection.getFirstElement();
		return entry.getTarget();
	}
}
