/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/posix/usr/src/sys/lowlib/lowlib.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */
static char rcsid[] = "@(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/posix/usr/src/sys/lowlib/lowlib.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";

/*
 * $Log: lowlib.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.7  1995-09-21 15:52:57  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.6  1995/07/06  15:23:30  night
 * ѿ user_stack_top  user_stack_bottom Ȥ̾ѹ
 * 桼åΰ BTRON Ķ˹碌 0x40000000 祢ɥ쥹
 *   Ȥʤ褦ѹ
 *
 * Revision 1.5  1995/03/18  14:27:42  night
 * errno ɲá
 * setup_trap_entry() ؿɲá
 * posix_exit() ؿɲá
 *
 * Revision 1.4  1995/02/21  15:20:53  night
 * 桼Υå˰ʸνüʸȤˡ
 * ߤΥ桼åݥ󥿤Υȥåפ򼨤Ƥ user_stack_top ѿ
 * 㥹ȤԤ褦ѹ
 *
 * Revision 1.3  1995/02/21  15:14:47  night
 * ʥ뵡뤿δؿ init_signal_handler_table () 
 * init_signal() ѹ
 * ޤ桼ץΥå뤿νɲä
 *
 * Revision 1.2  1995/02/20  15:20:56  night
 * ;ʬ (Ť RCS  LOG ޥäƤʬ) 
 *
 * Revision 1.1  1995/02/20  15:16:40  night
 * ϤƤϿ
 *
 */

/* lowlib for posix subsystem.
 *
 *
 * POSIX ֥ƥѤ LOWLIB.
 *
 *
 */

#include <sys/types.h>
#include <errno.h>
#include <sys/portmanager.h>
#include <server/memory.h>
#include "funcs.h"

/*								*/
/* ѿ򤹤뤿ΰ (ºݤ˾ݤ)	*/
/*								*/


/*
 *  lowlib ưƤץ ID 
 * (ץޥ͡㤫餦)
 */
pid_t	my_pid;

/*
 * 桼֤顼ֹ
 */
int	errno;

/*
 * ݡȥޥ͡㤫뤿ΰ衣
 */
struct recv_port_message_t		recv_msg;


/*
 * ɽؿ
 */

static VP	make_stack_frame (VP user_stack_bottom, int argc, 
				  char **argv, char *envp);
static void	init_user_memory (VP *user_stack_bottom, VP start_heap);
static void	setup_trap_entry (int (*posix_entry)());

/* 
 * POSIX LOWLIB νԤ
 * λȤϡ桼ץ startup ؿƤӤ
 *
 * LOWLIB ϡPOSIX ץޥ͡㤫鵯ư롣
 * ΤȤˡPOSIX ץޥ͡ϡå˥ץ
 * ؤΰϤ(å˰ξ񤭹Ǥ)
 *
 */
lowlib_start (B stack_top)
{
  /* 
   * lowlib Ȥ 
   */
  struct a
    {
      int	(*ap_start)();	/* 桼ץΥȥꥢɥ쥹 */
      int	argc;		/* 桼ץϤ argc */
      char	**argv;		/* 桼ץϤ argv */
      char	*envp;		/* 桼ץδĶѿ */
      VP	start_heap;	/* 桼ץΥҡΰ */
				/* Ƭɥ쥹 */
      pid_t	pid;		/* Υץ ID */
    } *args = (struct a *)&stack_top;

  VP		user_stack_bottom;	/* 桼åΥܥȥqɥ쥹 */
  extern int	posix_entry();


  my_pid = args->pid;	/* LOWLIB ŽĤƤץ */
                        /* ID 򵭲롣*/

  /*
   * 桼ץΤΥΰΥåȥå
   */
  init_user_memory (&user_stack_bottom, args->start_heap);

  /*
   * 桼 entry 롼ΤΥåե졼롣 
   */
  user_stack_bottom = make_stack_frame (user_stack_bottom,
				     args->argc, 
				     args->argv, 
				     args->envp);

  /* 
   * ǡʥ뵡
   * ʥϥɥνͤ POSIX λͤ˽
   * ʥȤ뤿Υư롣
   */
  init_signal ();

  /*
   * POSIX LOWLIB γߥȥ롼ꤹ롣
   * POSIX ƥॳϡꤷ posix_entry () Ȥʤ롣
   */
  setup_trap_entry (posix_entry);

  /*
   * ǡ桼ץΥȥå״ؿ򥳡뤹롣
   * lowlib ϥͥ⡼ɤưƤΤǡ桼⡼ɤܤʤ
   * Фʤ
   * Τˡ֥Ǻؿ jmp_user_entry () ƤǤ
   * 롣
   */
  jmp_user_entry ();

  /*
   * ˤϡäƤʤ⤷ɤäƤˤϡ桼ץ
   * ˴Ԥ
   */
  posix_exit ();
}


/*
 * 桼ץΤΥΰΥåȥå
 * o åΰΤ region 
 * o ҡפ˻Ѥ뤿 region 
 * (ޥ͡׵᤹)
 * δؿϡ桼åΥȥåץɥ쥹֤
 */
static void
init_user_memory (VP *user_stack_bottom, VP start_heap)
{
  W	error;

  /*
   * 桼åѤ region 롣
   * 桼åΰϼΤ褦˷롣
   *  start: 0x30000000
   *  size:  256MB
   * ʤvm_create() ϥޥ͡ΰݤ׵Ԥ
   */
  error = vm_create (get_tid(), 
		     0x30000000,
		     256 * 1024 * 1024, 
		     (VM_READ | VM_WRITE),
		     VM_USER);
  if (error != PE_OK)
    {
      /* 
       * ΰγݤ˼Ԥ
       * ΥϽλ롣
       */
      posix_exit ();
    }
  user_stack_bottom = (void *)0x3ffffff4;

  /*
   * ҡѤΥꤹ롣
   *  start:  start_heap ǻ
   *  size:  500M - start_heap
   */
  error = vm_create (get_tid (),
		     start_heap,
		     (500 * 1024 * 1024) - (int)start_heap,
		     (VM_READ | VM_WRITE),
		     VM_USER);
  if (error != PE_OK)
    {
      /* 
       * ΰγݤ˼Ԥ
       * ΥϽλ롣
       */
      posix_exit ();
    }
}

/*
 * ǡ桼 entry 롼ΤΥåե졼롣 
 * 桼åΥȥåפ򼨤ݥ user_stack_bottom Ȥꡢ
 * åե졼 argc, argv, envp Ƥ
 * (envp ˤĤƤϡĶѿΤ򥹥åե졼ߡ
 * ΰ򤵤˥åꤹ)
 * δؿϡåե졼Υȥåץɥ쥹֤
 *
 * δؿ¹ԤȤϡ桼ΥåϼΤ褦ˤʤ롣
 *
 *	+----------------------+ <-- return address.
 *	|    Argument Count    | 
 *	+----------------------+
 *	|    Argument Vector   |
 *	+----------------------+
 *	|    Environment       |
 *	+----------------------+
 *	|                      |
 *      //   ʸ     //
 *	|    ơ֥          |
 *	+----------------------+
 *	|                      |
 *	//   Ķѿ          //
 *	|      μǼΰ      | <- user_stack_bottom ()
 *	+----------------------+
 *
 */
static VP
make_stack_frame (VP user_stack_bottom, int argc, char **argv, char *envp)
{
  int	count;

  /*
   * ޤĶѿѤΰݤ
   */
  (char *)user_stack_bottom = (char *)user_stack_bottom - (strlen (envp) + 1);

  /*
   * ݤΰ˴Ķѿ򥳥ԡ 
   */
  strcpy (user_stack_bottom, envp);

  /*
   * Ķѿΰ򼨤ݥ󥿤򥹥å push  
   */
  envp = user_stack_bottom;
  (char **)user_stack_bottom = (char **)user_stack_bottom - 1;
  bcopy (envp, user_stack_bottom, sizeof (char *));

  /*
   * ĶѿƱͤ˰ʸѤΰݤ롣
   */
  for (count = argc - 1; count >= 0; count--)
    {
      (char *)user_stack_bottom = (char *)user_stack_bottom - (strlen (argv[count]) + 1);
      strcpy (user_stack_bottom, argv[count]);
      ((char *)user_stack_bottom)[strlen (argv[count])] = '\0';
    }

  /*
   * Ǹ˰ο򥹥å push 롣
   */
  (int *)user_stack_bottom += 1;
  *(int *)user_stack_bottom = argc;

  /*
   * 桼åΥȥåפ֤
   */
  return (user_stack_bottom);
}

/*
 * POSIX LOWLIB γߥȥ롼ꤹ롣
 * POSIX ƥॳϡꤷ posix_entry () Ȥʤ롣 
 */
static void
setup_trap_entry (int (*posix_entry)())
{
  /*
   * ITRON ˤγߥ٥ϿƥॳѤ롣
   */

}

/*
 * POSIX ץλ롣
 * POSIX ץ()ѤƤ񸻤򥷥ƥֵѤ
 * ٤ƤΥλ롣
 */
void
posix_exit (void)
{
  /*
   * 桼ץʬѤƤ۵ΰ롣
   */
  

  /*
   * ơǸ˼ʬȤλ롣
   */
  exd_tsk ();
}

