/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#) $Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/kernlib/port_manager.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $ */
static char rcsid[] = "@(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/kernlib/port_manager.c,v 1.1 2011/12/27 17:13:36 liu1 Exp $";

/*
 * $Log: port_manager.c,v $
 * Revision 1.1  2011/12/27 17:13:36  liu1
 * Initial Version.
 *
 * Revision 1.4  1995-12-05 15:10:22  night
 * unregist_port () ɲá
 *
 * Revision 1.3  1995/09/21  15:51:42  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.2  1995/06/28  14:14:25  night
 * print ʸ #ifdef DEBUG  #endif ǰϤä
 *
 * Revision 1.1  1995/02/26  14:18:12  night
 * ǽϿ
 *
 *
 */
/*
 * ݡȥޥ͡Ȥ̿ñ˹ԤΥ饤֥ؿ
 *
 * regist_port (PORT_NAME name, ID port);   åХåե ID Ͽ
 * unregist_port (PORT_NAME name);	    åХåե ID 
 * find_port (PORT_NAME name, ID &port);    åХåե ID θ
 * alloc_port (void);                       ݡȤ
 */

#include <itron.h>
#include <errno.h>
#include <types.h>
#include "../servers/port-manager.h"
#include "libkernel.h"

/*
 * ݡȥޥ͡˥åХåեϿ롣
 * δؿǰŪ˼ѤΥåݡȤ롣
 *
 */
PORT_MANAGER_ERROR
regist_port (PORT_NAME *name, ID port)
{
  struct recv_port_message_t	recv_msg;
  struct port_manager_msg_t  	send_msg;
  ID			     	recv_port;
  W			     	rsize;


  /*
   * ݡȥޥ͡㤫ĤѤΥåХåե
   */
  recv_port = get_port (sizeof (recv_msg), sizeof (recv_msg));
  if (recv_port == 0)
    {
#ifdef DEBUG
      dbg_printf ("regist_port: cannot get port.\n");
#endif /* DEBUG */
      return (E_PORT_SYSTEM);
    }

  /*
   * ݡȥޥ͡׵å
   */
  send_msg.hdr.type  = REGIST_PORT;
  send_msg.hdr.size  = sizeof (send_msg);
  send_msg.hdr.rport = recv_port;
  strcpy (&(send_msg.body.regist.name), name);
  send_msg.body.regist.port = port;

#ifdef DEBUG
  dbg_printf ("regist_port: name = <%s>\n", &(send_msg.body.regist.name));
#endif /* DEBUG */

  /*
   * ݡȥޥ͡ФϿ׵å롣
   */
  if (snd_mbf (PORT_MANAGER_PORT, sizeof (send_msg), &send_msg) != E_OK)
    {
      del_mbf (recv_port);
      return (E_PORT_SYSTEM);
    }

#ifdef DEBUG
  dbg_printf ("port_manager:snd_msg: ok.\n");
#endif /* DEBUG */

  /*
   * ݡȥޥ͡㤫åμĤ
   */
  if (rcv_mbf (&recv_msg, &rsize, recv_port) != E_OK)
    {
      del_mbf (recv_port);
      return (E_PORT_SYSTEM);
    }

#ifdef DEBUG
  dbg_printf ("port_manager:rcv_msg: ok.\n");
#endif /* DEBUG */


  /*
   * ȤäѤΥåХåե롣
   */
  del_mbf (recv_port);

#ifdef DEBUG
  dbg_printf ("port_manager: errno = %d\n", recv_msg.error);
#endif /* DEBUG */
  return (recv_msg.error);
}

PORT_MANAGER_ERROR
unregist_port (PORT_NAME *name)
{
  struct recv_port_message_t	recv_msg;
  struct port_manager_msg_t  	send_msg;
  ID			     	recv_port;
  W			     	rsize;


  /*
   * ݡȥޥ͡㤫ĤѤΥåХåե
   */
  recv_port = get_port (sizeof (recv_msg), sizeof (recv_msg));
  if (recv_port == 0)
    {
#ifdef DEBUG
      dbg_printf ("regist_port: cannot get port.\n");
#endif /* DEBUG */
      return (E_PORT_SYSTEM);
    }

  /*
   * ݡȥޥ͡׵å
   */
  send_msg.hdr.type  = UNREGIST_PORT;
  send_msg.hdr.size  = sizeof (send_msg);
  send_msg.hdr.rport = recv_port;
  strcpy (&(send_msg.body.regist.name), name);

#ifdef DEBUG
  dbg_printf ("regist_port: name = <%s>\n", &(send_msg.body.regist.name));
#endif /* DEBUG */

  /*
   * ݡȥޥ͡ФϿ׵å롣
   */
  if (snd_mbf (PORT_MANAGER_PORT, sizeof (send_msg), &send_msg) != E_OK)
    {
      del_mbf (recv_port);
      return (E_PORT_SYSTEM);
    }

#ifdef DEBUG
  dbg_printf ("port_manager:snd_msg: ok.\n");
#endif /* DEBUG */

  /*
   * ݡȥޥ͡㤫åμĤ
   */
  if (rcv_mbf (&recv_msg, &rsize, recv_port) != E_OK)
    {
      del_mbf (recv_port);
      return (E_PORT_SYSTEM);
    }

#ifdef DEBUG
  dbg_printf ("port_manager:rcv_msg: ok.\n");
#endif /* DEBUG */


  /*
   * ȤäѤΥåХåե롣
   */
  del_mbf (recv_port);

#ifdef DEBUG
  dbg_printf ("port_manager: errno = %d\n", recv_msg.error);
#endif /* DEBUG */
  return (recv_msg.error);
}


/*
 * ݡȥޥ͡㤫åХåե򸡺롣
 * δؿǰŪ˼ѤΥåݡȤ롣
 *
 */
PORT_MANAGER_ERROR
find_port (PORT_NAME *name, ID *rport)
{
  struct recv_port_message_t	recv_msg;
  struct port_manager_msg_t  	send_msg;
  ID			     	recv_port;
  W			     	rsize;


  /*
   * ݡȥޥ͡㤫ĤѤΥåХåե
   */
  recv_port = get_port (sizeof (recv_msg), sizeof (recv_msg));
  if (recv_port == 0)
    {
#ifdef DEBUG
      dbg_printf ("regist_port: cannot get port.\n");
#endif /* DEBUG */
      return (E_PORT_SYSTEM);
    }

  /*
   * ݡȥޥ͡׵å
   */
  send_msg.hdr.type  = FIND_PORT;
  send_msg.hdr.size  = sizeof (send_msg);
  send_msg.hdr.rport = recv_port;
  strcpy (&(send_msg.body.find.name), name);

#ifdef DEBUG
  dbg_printf ("find_port: name = <%s>\n", &(send_msg.body.find.name));
#endif /* DEBUG */
  /*
   * ݡȥޥ͡ФƸ׵å롣
   */
  if (snd_mbf (PORT_MANAGER_PORT, sizeof (send_msg), &send_msg) != E_OK)
    {
      del_mbf (recv_port);
      return (E_PORT_SYSTEM);
    }

#ifdef DEBUG
  dbg_printf ("port_manager:snd_msg: ok.\n");
#endif /* DEBUG */

  /*
   * ݡȥޥ͡㤫åμĤ
   */
  if (rcv_mbf (&recv_msg, &rsize, recv_port) != E_OK)
    {
      del_mbf (recv_port);
      return (E_PORT_SYSTEM);
    }

#ifdef DEBUG
  dbg_printf ("port_manager:rcv_msg: ok.\n");
#endif /* DEBUG */

  /*
   * ݡȥޥ͡㤬ݡֹ֤
   */
  *rport = recv_msg.port;

  /*
   * ȤäѤΥåХåե롣
   */
  del_mbf (recv_port);

#ifdef DEBUG
  dbg_printf ("port_manager: errno = %d\n", recv_msg.error);
#endif /* DEBUG */
  return (recv_msg.error);
}

/*
 * åХåե롣
 * åХåե ID ϡưŪ˶ƤΤѤ롣
 *
 */
ID
alloc_port (W size, W max_entry)
{
  ID		msg_port;
  T_CMBF	create_argument;

  /*
   * ׵ĤΤΥåХåե롣
   * åХåե ID ä˷ޤäƤʤƤå
   * ХåեŬ֡
   */
  create_argument.bufsz  = size;
  create_argument.maxmsz = size * max_entry;
  create_argument.mbfatr = TA_TFIFO;
  for (msg_port = MIN_USERMBFID;
       msg_port <= MAX_USERMBFID;
       msg_port++)
    {
      if (cre_mbf (msg_port, &create_argument) == E_OK)
	{
	  /*
	   * åХåեμ
	   */
	  return (msg_port);
	}
    }

  /*
   * åХåեǤʤä
   */
#ifdef DEBUG
  dbg_printf ("posix.process server: cannot allocate messege buffer\n");
#endif /* DEBUG */
  return (0);
}
