#pragma once
#include "BITSExplorerView.h"


class CMainFrame :	public CFrameWindowImpl<CMainFrame>,
					public CUpdateUI<CMainFrame>,
					public CMessageFilter,
					public CIdleHandler
{
public:
	DECLARE_FRAME_WND_CLASS(NULL, IDR_MAINFRAME)

	BEGIN_UPDATE_UI_MAP(CMainFrame)
		UPDATE_ELEMENT(ID_FILE_NEW,			UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_STATUS_BAR,	UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_TOOLBAR,		UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_SET_500MS_REFRESH_INTERVAL,		UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_SET_1000MS_REFRESH_INTERVAL,		UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_SET_2000MS_REFRESH_INTERVAL,		UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_SET_5000MS_REFRESH_INTERVAL,		UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_SET_10000MS_REFRESH_INTERVAL,	UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_STOP_AUTO_REFRESH,				UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_VIEW_DISPLAY_ALL_USERS_JOBS,			UPDUI_MENUPOPUP)
		UPDATE_ELEMENT(ID_JOB_COMPLETE,		UPDUI_MENUPOPUP | UPDUI_TOOLBAR)
		UPDATE_ELEMENT(ID_JOB_CANCEL,		UPDUI_MENUPOPUP | UPDUI_TOOLBAR)
		UPDATE_ELEMENT(ID_JOB_RESUME,		UPDUI_MENUPOPUP | UPDUI_TOOLBAR)
		UPDATE_ELEMENT(ID_JOB_SUSPEND,		UPDUI_MENUPOPUP | UPDUI_TOOLBAR)
		UPDATE_ELEMENT(ID_JOB_PROPERTY,		UPDUI_MENUPOPUP | UPDUI_TOOLBAR)
	END_UPDATE_UI_MAP()

	BEGIN_MSG_MAP(CMainFrame)
		MSG_WM_CREATE(OnCreate)
		MSG_WM_DESTROY(OnDestroy)
		MSG_WM_TIMER(OnTimer)
		MSG_WM_INITMENU(OnInitMenu)
		COMMAND_ID_HANDLER_EX(ID_FILE_NEW,			OnFileNew)
		COMMAND_ID_HANDLER_EX(ID_APP_EXIT,			OnFileExit)
		COMMAND_ID_HANDLER_EX(ID_VIEW_REFRESH,		OnViewRefresh)
		COMMAND_ID_HANDLER_EX(ID_VIEW_STATUS_BAR,	OnViewStatusBar)
		COMMAND_ID_HANDLER_EX(ID_VIEW_TOOLBAR,		OnViewToolBar)
		COMMAND_ID_HANDLER_EX(ID_VIEW_DISPLAY_ALL_USERS_JOBS,		OnViewDisplayAllUsersJobs)
		COMMAND_ID_HANDLER_EX(ID_APP_ABOUT,			OnAppAbout)
		COMMAND_ID_HANDLER_EX(ID_JOB_COMPLETE,		OnCompleteJob)
		COMMAND_ID_HANDLER_EX(ID_JOB_CANCEL,		OnCancelJob)
		COMMAND_ID_HANDLER_EX(ID_JOB_RESUME,		OnResumeJob)
		COMMAND_ID_HANDLER_EX(ID_JOB_SUSPEND,		OnSuspendJob)
		COMMAND_ID_HANDLER_EX(ID_JOB_PROPERTY,		OnProperty)
		NOTIFY_CODE_HANDLER_EX(LVN_ITEMCHANGED,		OnJobListViewItemChanged)
		COMMAND_RANGE_HANDLER_EX(ID_VIEW_SET_500MS_REFRESH_INTERVAL, ID_VIEW_STOP_AUTO_REFRESH, OnRefreshIntervalMenuSelected)
		CHAIN_MSG_MAP(CUpdateUI<CMainFrame>)
		CHAIN_MSG_MAP(CFrameWindowImpl<CMainFrame>)
		REFLECT_NOTIFICATIONS()
	END_MSG_MAP()

	static const DWORD REFRESH_TIMER_ID			= 128;	
	static const DWORD DEFAULT_REFRESH_INTERVAL = 1 * 1000;
	static const DWORD DISABLE_AUTO_REFRESH		= 0;
	static const DWORD CLEAN_UP_COUNT			= 5;

	CBITSExplorerView m_view;

	CMainFrame();

	virtual BOOL PreTranslateMessage(__in MSG* pMsg);

private:
	DWORD m_dwRefreshInterval;
	DWORD m_dwRefreshCount;
	bool  m_bDisplyAllUsersJobs;
	bool  m_bMenuIntialized;

	CBitmap m_UACShieldBitmap;

	LRESULT OnCreate(__in CREATESTRUCT* lpCreateStruct);
	LRESULT OnDestroy(void);
	LRESULT OnTimer(__in UINT_PTR nIDEvent);
	void OnInitMenu(__in CMenuHandle menu);
	LRESULT OnJobListViewItemChanged(LPNMHDR pnmh);

	virtual BOOL OnIdle(void);

	LRESULT OnFileNew(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnFileExit(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnViewRefresh(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnViewStatusBar(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnViewToolBar(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnViewDisplayAllUsersJobs(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnAppAbout(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnCompleteJob(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnCancelJob(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnResumeJob(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnSuspendJob(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnProperty(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	void OnRefreshIntervalMenuSelected(UINT /*uNotifyCode*/, int nID, CWindow /*wndCtl*/);

	bool CreateView(void);
	bool RetrieveUACShieldIcon(void);

	bool SetToolBarStyle(void);
	bool SetDisabledToolBarImage(void);
	bool SetApplicationTitle(void);

	bool UpdateUI(void);
	bool UpdateViewMenu(void);

	bool ModifyDisplayAllUserJobsMenu(__in CMenuHandle& viewMenu);
	
	__checkReturn bool NeedCleanUpOldItems(void);

	bool SetAutoRefreshSetting(void);
	__checkReturn bool IsAutoRefreshEnabled(void);
};
