#pragma once
#include "resource.h"


class CJobChangeReplyFilePathDlg: public CDialogImpl<CJobChangeReplyFilePathDlg>,
	public CWinDataExchange<CJobChangeReplyFilePathDlg>
{
public:
	enum { IDD = IDD_CHANGE_REPLY_FILE_PATH };

	BEGIN_DDX_MAP(CJobChangeReplyFilePathDlg)
		DDX_CONTROL_HANDLE(IDOK,						m_buttonOK)
		DDX_CONTROL_HANDLE(IDC_EDIT_REPLY_FILE_PATH,	m_editReplyFilePath)
		DDX_CONTROL_HANDLE(IDC_BUTTON_BROWSE,			m_buttonBrowse)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobChangeReplyFilePathDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDOK,					OnOK)
		COMMAND_ID_HANDLER_EX(IDCANCEL,				OnCancel)
		COMMAND_ID_HANDLER_EX(IDC_BUTTON_BROWSE,	OnBrowseButtonDown)
		COMMAND_HANDLER_EX(IDC_EDIT_REPLY_FILE_PATH,	EN_CHANGE,	OnEnChangeReplyFilePath)
	END_MSG_MAP()

	CJobChangeReplyFilePathDlg(void);
	~CJobChangeReplyFilePathDlg(void);

	CString GetReplyFilePath(void);
	void SetReplyFilePath(__in LPCWSTR lpszReplyFilePath);

private:
	CEdit	m_editReplyFilePath;
	CButton m_buttonBrowse;
	CButton	m_buttonOK;

	CString m_strReplyFilePath;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/);
	LRESULT OnBrowseButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeReplyFilePath(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitDialogControls(void);
	bool UpdateUI(void);
	__checkReturn bool CheckReplyFilePath(void);
};
