#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobAdvancedSetting3Page: public CPropertyPageImpl<CJobAdvancedSetting3Page>,
	public CWinDataExchange<CJobAdvancedSetting3Page>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_ADVANCED_SETTING3 };

	BEGIN_DDX_MAP(CJobAdvancedSetting3Page)
		DDX_CONTROL_HANDLE(IDC_EDIT_CUSTOM_HEADERS,				m_editCustomHeaders)
		DDX_CONTROL_HANDLE(IDC_BUTTON_CHANGE_CUSTOM_HEADERS,	m_buttonChangeCustomHeaders)
		DDX_CONTROL_HANDLE(IDC_BUTTON_REMOVE_CUSTOM_HEADERS,	m_buttonRemoveCustomHeaders)
		DDX_CONTROL_HANDLE(IDC_COMBO_CERT_LOCATION,				m_comboCertLocation)
		DDX_CONTROL_HANDLE(IDC_COMBO_CERT_STORE_NAME,			m_comboCertStoreName)
		DDX_CONTROL_HANDLE(IDC_RADIO_CERT_SUBJECT_NAME,			m_radioCertSubjectName)
		DDX_CONTROL_HANDLE(IDC_RADIO_CERT_SHA1_HASH,			m_radioCertSHA1Hash)
		DDX_CONTROL_HANDLE(IDC_EDIT_CERT_DATA,					m_editCertData)
		DDX_CONTROL_HANDLE(IDC_BUTTON_SET_CERT,					m_buttonSetCert)
		DDX_CONTROL_HANDLE(IDC_BUTTON_REMOVE_CERT,				m_buttonRemoveCert)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobAdvancedSetting3Page)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_HANDLER_EX(IDC_BUTTON_CHANGE_CUSTOM_HEADERS,	BN_CLICKED,		OnChangeCustomHeadersButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_REMOVE_CUSTOM_HEADERS,	BN_CLICKED,		OnRemoveCustomHeadersButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_SET_CERT,					BN_CLICKED,		OnSetCertButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_REMOVE_CERT,				BN_CLICKED,		OnRemoveCertButtonDown)
		COMMAND_HANDLER_EX(IDC_EDIT_CUSTOM_HEADERS,				EN_CHANGE,		OnEnChangeCustomHeaders)
		COMMAND_HANDLER_EX(IDC_COMBO_CERT_STORE_NAME,			CBN_EDITCHANGE,	OnCertComboBoxSelChanged)
		COMMAND_RANGE_CODE_HANDLER_EX(IDC_COMBO_CERT_LOCATION,		IDC_COMBO_CERT_STORE_NAME,	CBN_SELCHANGE,	OnCertComboBoxSelChanged)
		COMMAND_RANGE_CODE_HANDLER_EX(IDC_RADIO_CERT_SUBJECT_NAME,	IDC_RADIO_CERT_SHA1_HASH,	BN_CLICKED,		OnRadioButtonClicked)
		COMMAND_HANDLER_EX(IDC_EDIT_CERT_DATA,					EN_CHANGE,		OnEnChangeCertData)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobAdvancedSetting3Page>)
	END_MSG_MAP()

	CJobAdvancedSetting3Page(void);
	~CJobAdvancedSetting3Page(void);

	__checkReturn bool IsBITS25Supported(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);


private:
	CComPtr<IBackgroundCopyManager>				m_spBITSManager;
	CComQIPtr<IBackgroundCopyJob4>				m_spJob4;
	CComQIPtr<IBackgroundCopyJobHttpOptions>	m_spHttpOptions;

	CEdit			m_editCustomHeaders;
	CButton			m_buttonChangeCustomHeaders;
	CButton			m_buttonRemoveCustomHeaders;
	CComboBox		m_comboCertLocation;
	CComboBox		m_comboCertStoreName;
	CButton			m_radioCertSubjectName;
	CButton			m_radioCertSHA1Hash;
	CEdit			m_editCertData;
	CButton			m_buttonSetCert;
	CButton			m_buttonRemoveCert;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnEnChangeCustomHeaders(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnChangeCustomHeadersButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnRemoveCustomHeadersButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnRadioButtonClicked(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnCertComboBoxSelChanged(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeCertData(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnSetCertButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnRemoveCertButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitPropertyPageControls(void);
	bool InitCustomHeadersControls(void);
	bool InitCertControls(void);
	bool InitCertLocationComboBox(void);
	bool InitCertNameComboBox(void);

	bool ResetCertControls(void);

	bool RefreshUI(void);
	bool RefreshCustomHeadersInfo(void);

	bool UpdateUI(void);
	bool UpdateCustomHeadersControls(void);
	bool UpdateCertControls(void);


	BG_CERT_STORE_LOCATION GetCertStoreLocationFromComboBox(void);
	bool SetCertStoreLocationToComboBox(__in BG_CERT_STORE_LOCATION certStoreLocation);

	BITS_CERT_STORE_ID GetCertStoreNameFromComboBox(void);
	bool SetCertStoreNameToComboBox(__in BITS_CERT_STORE_ID certStoreLocation);

	__checkReturn BITS_CERT_STORE_ID CertStoreIdFromString(__in LPCWSTR lpszCertStoreName);
	__checkReturn CString CertStoreStringFromId(__in BITS_CERT_STORE_ID certStoreId);
};
