#include "StdAfx.h"
#include "JobPropertySheet.h"
#include "BITSUtil.h"


CJobPropertySheet::CJobPropertySheet(__in ATL::_U_STRINGorID title, UINT uStartPage, HWND hWndParent):
	CPropertySheetImpl(title, uStartPage, hWndParent)
{
	NULL;
}


int CALLBACK CJobPropertySheet::PropSheetCallback(__in HWND hWnd, __in UINT uMsg, __in LPARAM lParam)
{
	if (uMsg == PSCB_PRECREATE) {
		reinterpret_cast<LPDLGTEMPLATE>(lParam)->style &= ~DS_CONTEXTHELP;
		return 0;
	}

	return CPropertySheetImpl<CJobPropertySheet>::PropSheetCallback(hWnd, uMsg, lParam);
}


void CJobPropertySheet::AddPages(void)
{
	ATLVERIFY(AddPage(m_jobGeneralPage));
	if (EDIT_JOB_MODE == m_jobGeneralPage.GetJobEditMode()) {
		ATLVERIFY(AddPage(m_jobStatusPage));
		ATLVERIFY(AddPage(m_jobErrorDetailsPage));
		ATLVERIFY(AddPage(m_jobProxySettingPage));

		if (true == m_jobAdvancedSetting1Page.IsBITS15Supported()) {
			ATLVERIFY(AddPage(m_jobFileDetailsPage));
			ATLVERIFY(AddPage(m_jobAdvancedSetting1Page));
		}
		if (true == m_jobAdvancedSetting2Page.IsBITS20Supported()) {
			ATLVERIFY(AddPage(m_jobAdvancedSetting2Page));
		}
		if (true == m_jobAdvancedSetting3Page.IsBITS25Supported()) {
			ATLVERIFY(AddPage(m_jobAdvancedSetting3Page));
		}
		if (true == m_jobAdvancedSetting4Page.IsBITS40Supported()) {
			ATLVERIFY(AddPage(m_jobAdvancedSetting4Page));
		}
	}

	return;
}


void CJobPropertySheet::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);

	m_jobGeneralPage.SetBITSManagerIF(spBITSManager);
	m_jobStatusPage.SetBITSManagerIF(spBITSManager);
	m_jobErrorDetailsPage.SetBITSManagerIF(spBITSManager);
	m_jobProxySettingPage.SetBITSManagerIF(spBITSManager);
	m_jobFileDetailsPage.SetBITSManagerIF(spBITSManager);
	m_jobAdvancedSetting1Page.SetBITSManagerIF(spBITSManager);
	m_jobAdvancedSetting2Page.SetBITSManagerIF(spBITSManager);
	m_jobAdvancedSetting3Page.SetBITSManagerIF(spBITSManager);
	m_jobAdvancedSetting4Page.SetBITSManagerIF(spBITSManager);

	return;
}


void CJobPropertySheet::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);

	m_jobGeneralPage.SetJobIF(spJob);
	m_jobStatusPage.SetJobIF(spJob);
	m_jobErrorDetailsPage.SetJobIF(spJob);
	m_jobProxySettingPage.SetJobIF(spJob);
	
	if (true == BITSUtil::IsBITS15Supported(spJob)) {
		m_jobAdvancedSetting1Page.SetJobIF(spJob);
	}
	if (true == BITSUtil::IsBITS20Supported(spJob)) {
		m_jobFileDetailsPage.SetJobIF(spJob);
		m_jobAdvancedSetting2Page.SetJobIF(spJob);
	}
	if (true == BITSUtil::IsBITS25Supported(spJob)) {
		m_jobAdvancedSetting3Page.SetJobIF(spJob);
	}
	if (true == BITSUtil::IsBITS40Supported(spJob)) {
		m_jobAdvancedSetting4Page.SetJobIF(spJob);
	}
	
	return;
}


void CJobPropertySheet::SetJobEditMode(__in JOB_EDIT_MODE jobEditMode)
{
	ATLASSERT(INVALID_JOB_EDIT_MODE != jobEditMode);
	m_jobGeneralPage.SetJobEditMode(jobEditMode);

	return;
}
