#include "StdAfx.h"
#include "JobStatusPropertyPage.h"
#include "JobRetryDelaySettingDlg.h"
#include "JobNoProgressTimeoutSettingDlg.h"
#include "BITSUtil.h"
#include "MiscUtil.h"
#include "WTLCtrlUtil.h"


CJobStatusPropertyPage::CJobStatusPropertyPage(void)
{
	NULL;
}


CJobStatusPropertyPage::~CJobStatusPropertyPage(void)
{
	NULL;
}


LRESULT CJobStatusPropertyPage::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(RefreshUI());
	ATLVERIFY(SetTimer(REFRESH_TIMER_ID, REFRESH_INTERVAL));

	return TRUE;
}


LRESULT CJobStatusPropertyPage::OnDestroy(void)
{
	ATLVERIFY(KillTimer(REFRESH_TIMER_ID));

	return 0;
}


LRESULT CJobStatusPropertyPage::OnTimer(__in UINT_PTR nIDEvent)
{
	switch (nIDEvent) {
		case REFRESH_TIMER_ID:
			if (FALSE != IsWindowVisible()) {
				ATLVERIFY(RefreshUI());
			}
			break;

		default:
			break;
	}

	return 0;
}


int CJobStatusPropertyPage::OnApply(void)
{
	ATLVERIFY(DoDataExchange(TRUE));

	return 0;
}


LRESULT CJobStatusPropertyPage::OnModifyRetryDelayButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CJobRetryDelaySettingDlg dlg;
	dlg.SetJobIF(m_spJob);
	dlg.SetBITSManagerIF(m_spBITSManager);
	INT_PTR nResponse = dlg.DoModal(m_hWnd);
	if (IDOK == nResponse) {
		RefreshOtherProperty();
	}

	return 0;
}


LRESULT CJobStatusPropertyPage::OnModifyNoProgressTimeoutButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CJobNoProgressTimeoutSettingDlg dlg;
	dlg.SetJobIF(m_spJob);
	dlg.SetBITSManagerIF(m_spBITSManager);

	INT_PTR nResponse = dlg.DoModal(m_hWnd);
	if (IDOK == nResponse) {
		RefreshOtherProperty();
	}

	return 0;
}


LRESULT CJobStatusPropertyPage::OnTakeOwnershipButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	bool bOwner = false;
	HRESULT hr = BITSUtil::IsJobOwner(m_spJob, &bOwner);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_TAKE_OWNERSHIP_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	if (true == bOwner) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_HAVE_ALREADY_OWNERSHIP, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	if (0 == ::IsUserAnAdmin()) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NEED_ADMIN_PRIVILEGE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_TAKE_OWNERSHIP, IDR_MAINFRAME, 
		MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	hr = BITSUtil::TakeJobOwnership(m_spJob);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_TAKE_OWNERSHIP_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	return 0;
}


bool CJobStatusPropertyPage::RefreshUI(void)
{
	ATLVERIFY(RefreshGeneralProperty());
	ATLVERIFY(RefreshTimeInfo());
	ATLVERIFY(RefreshNotifyProperty());
	ATLVERIFY(RefreshProgressInfo());
	ATLVERIFY(RefreshOtherProperty());

	return true;
}


bool CJobStatusPropertyPage::RefreshGeneralProperty(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return false;
	}

	// WuƃWuID̓Rs[&y[Xgł悤ɃGfBbgRg[ɂĂ邪A
	// DDXŉʍXVƃRg[̃L[{[htH[JXZbgĂ܂̂ŁA
	// Rg[ɒڃeLXgZbg

	HRESULT hr = BITSUtil::GetJobDisplayName(m_spJob, &m_strJobDisplayName);
	ATLASSERT(SUCCEEDED(hr));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editJobDisplayName, m_strJobDisplayName));

	hr = BITSUtil::GetJobId(m_spJob, &m_strJobId);
	ATLASSERT(SUCCEEDED(hr));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editJobId, m_strJobId));

	BG_JOB_TYPE jobType = BG_JOB_TYPE_DOWNLOAD;
	hr = BITSUtil::GetJobType(m_spJob, &jobType);
	if (SUCCEEDED(hr)) {
		m_strJobType = MiscUtil::GetJobTypeString(jobType);
		ATLASSERT(!m_strJobType.IsEmpty());
	} else {
		ATLASSERT(false);
	}

	BG_JOB_PRIORITY jobPriority = BG_JOB_PRIORITY_NORMAL;
	hr = BITSUtil::GetJobPriority(m_spJob, &jobPriority);
	if (SUCCEEDED(hr)) {
		m_strJobPriority = MiscUtil::GetJobPriorityString(jobPriority);
		ATLASSERT(!m_strJobPriority.IsEmpty());
	} else {
		ATLASSERT(false);
	}

	BG_JOB_STATE jobState = BG_JOB_STATE_ERROR;
	hr = BITSUtil::GetJobState(m_spJob, &jobState);
	if (SUCCEEDED(hr)) {
		m_strJobState = MiscUtil::GetJobStateString(jobState);
		ATLASSERT(!m_strJobState.IsEmpty());
	} else {
		ATLASSERT(false);
	}

	hr = BITSUtil::GetJobOwner(m_spJob, &m_strJobOwner);
	ATLASSERT(SUCCEEDED(hr));

	ATLVERIFY(DoDataExchange(FALSE));

	return true;
}


bool CJobStatusPropertyPage::RefreshTimeInfo(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return false;
	}

	BG_JOB_TIMES time = {0};
	HRESULT hr = BITSUtil::GetJobTimes(m_spJob, &time);
	if (SUCCEEDED(hr)) {
		m_strCreationTime		= MiscUtil::GetTimeString(time.CreationTime);
		m_strModificationTime	= MiscUtil::GetTimeString(time.ModificationTime);
		m_strCompletionTime		= MiscUtil::GetTimeString(time.TransferCompletionTime);
	} else {
		ATLVERIFY(false);
	}

	ATLVERIFY(DoDataExchange(FALSE));

	return true;
}


bool CJobStatusPropertyPage::RefreshNotifyProperty(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return false;
	}

	CComPtr<IUnknown> spNotifyInterface;
	HRESULT hr = BITSUtil::GetJobNotifyInterface(m_spJob, reinterpret_cast<CComPtr<IUnknown>*>(&spNotifyInterface));
	ATLASSERT(SUCCEEDED(hr));
	if (spNotifyInterface) {
		BOOL bLoadResult = m_strNotifyInterface.LoadString(IDS_NOTIFY_INTERFACE_EXIST);
		ATLVERIFY(bLoadResult);
	} else {
		BOOL bLoadResult = m_strNotifyInterface.LoadString(IDS_NOTIFY_INTERFACE_NOT_EXIST);
		ATLVERIFY(bLoadResult);
	}

	ULONG uNotifyFlags = 0;
	hr = BITSUtil::GetJobNotifyFlags(m_spJob, &uNotifyFlags);
	ATLASSERT(SUCCEEDED(hr));

	if (BG_NOTIFY_JOB_TRANSFERRED & uNotifyFlags) {
		m_staticNotifyJobTransferred.EnableWindow(TRUE);
	} else {
		m_staticNotifyJobTransferred.EnableWindow(FALSE);
	}

	if (BG_NOTIFY_JOB_ERROR & uNotifyFlags) {
		m_staticNotifyJobError.EnableWindow(TRUE);
	} else {
		m_staticNotifyJobError.EnableWindow(FALSE);
	}

	if (BG_NOTIFY_DISABLE & uNotifyFlags) {
		m_staticNotifyDisabled.EnableWindow(TRUE);
	} else {
		m_staticNotifyDisabled.EnableWindow(FALSE);
	}

	if (BG_NOTIFY_JOB_MODIFICATION & uNotifyFlags) {
		m_staticNotifyJobModification.EnableWindow(TRUE);
	} else {
		m_staticNotifyJobModification.EnableWindow(FALSE);
	}

	if (BG_NOTIFY_FILE_TRANSFERRED & uNotifyFlags) {
		m_staticNotifyFileTransferred.EnableWindow(TRUE);
	} else {
		m_staticNotifyFileTransferred.EnableWindow(FALSE);
	}

	ATLVERIFY(DoDataExchange(FALSE));

	return true;
}


bool CJobStatusPropertyPage::RefreshProgressInfo(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return false;
	}

	BG_JOB_PROGRESS progress = {0};
	HRESULT hr = BITSUtil::GetJobProgress(m_spJob, &progress);
	ATLASSERT(SUCCEEDED(hr));
	if (BG_SIZE_UNKNOWN != progress.BytesTotal) {
		m_strTotalByte	= MiscUtil::FormatNumber(progress.BytesTotal);
	} else {
		m_strTotalByte	= MiscUtil::FormatNumber(0);
	}

	m_strTotalFile			= MiscUtil::FormatNumber(progress.FilesTotal);
	m_strByteTransferred	= MiscUtil::FormatNumber(progress.BytesTransferred);
	m_strFileTransferred	= MiscUtil::FormatNumber(progress.FilesTransferred);

	ULONG uErrorCount = 0;
	hr = BITSUtil::GetJobErrorCount(m_spJob, &uErrorCount);
	ATLASSERT(SUCCEEDED(hr));
	m_strErrorCount = MiscUtil::FormatNumber(uErrorCount);

	ATLVERIFY(DoDataExchange(FALSE));

	return true;
}


bool CJobStatusPropertyPage::RefreshOtherProperty(void)
{
	if (!m_spJob) {
		ATLASSERT(false);
		return false;
	}

	ULONG uRetryDelay = 0;
	HRESULT hr = BITSUtil::GetJobMinimumRetryDelay(m_spJob, &uRetryDelay);
	ATLASSERT(SUCCEEDED(hr));
	m_strRetryDelay = MiscUtil::FormatNumber(uRetryDelay);

	ULONG uNoProgressTimeout = 0;
	hr = BITSUtil::GetJobNoProgressTimeout(m_spJob, &uNoProgressTimeout);
	ATLASSERT(SUCCEEDED(hr));
	m_strNoProgressTimeout = MiscUtil::FormatNumber(uNoProgressTimeout);

	ATLVERIFY(DoDataExchange(FALSE));

	return true;
}


void CJobStatusPropertyPage::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobStatusPropertyPage::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}

	m_spJob = spJob;

	return;
}

