using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using mshtml;
using System.Security;

namespace ProjectBoon.Win32
{

	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("bd3f23c0-d43e-11cf-893b-00aa00bdce1a")]
	public interface IDocHostUIHandler_HRES
	{
		[PreserveSig]
		int ShowContextMenu([In, MarshalAs(UnmanagedType.U4)] int dwID, [In] POINT pt, [In, MarshalAs(UnmanagedType.Interface)] object pcmdtReserved, [In, MarshalAs(UnmanagedType.Interface)] object pdispReserved);
		[PreserveSig]
		int GetHostInfo([In, Out] DOCHOSTUIINFO info);
		[PreserveSig]
		int ShowUI([In, MarshalAs(UnmanagedType.I4)] int dwID, [In] IOleInPlaceActiveObject activeObject, [In] IOleCommandTarget commandTarget, [In] IOleInPlaceFrame frame, [In] IOleInPlaceUIWindow doc);
		[PreserveSig]
		int HideUI();
		[PreserveSig]
		int UpdateUI();
		[PreserveSig]
		int EnableModeless([In, MarshalAs(UnmanagedType.Bool)] bool fEnable);
		[PreserveSig]
		int OnDocWindowActivate([In, MarshalAs(UnmanagedType.Bool)] bool fActivate);
		[PreserveSig]
		int OnFrameWindowActivate([In, MarshalAs(UnmanagedType.Bool)] bool fActivate);
		[PreserveSig]
		int ResizeBorder([In] COMRECT rect, [In] IOleInPlaceUIWindow doc, bool fFrameWindow);
		[PreserveSig]
		int TranslateAccelerator([In] ref MSG msg, [In] ref Guid group, [In, MarshalAs(UnmanagedType.I4)] int nCmdID);
		[PreserveSig]
		int GetOptionKeyPath([Out, MarshalAs(UnmanagedType.LPArray)] string[] pbstrKey, [In, MarshalAs(UnmanagedType.U4)] int dw);
		[PreserveSig]
		int GetDropTarget([In, MarshalAs(UnmanagedType.Interface)] IOleDropTarget pDropTarget, [MarshalAs(UnmanagedType.Interface)] out IOleDropTarget ppDropTarget);
		[PreserveSig]
		int GetExternal([MarshalAs(UnmanagedType.Interface)] out object ppDispatch);
		[PreserveSig]
		int TranslateUrl([In, MarshalAs(UnmanagedType.U4)] int dwTranslate, [In, MarshalAs(UnmanagedType.LPWStr)] string strURLIn, [MarshalAs(UnmanagedType.LPWStr)] out string pstrURLOut);
		[PreserveSig]
		int FilterDataObject(IDataObject pDO, out IDataObject ppDORet);
	}

	[ComImport,
	InterfaceType(ComInterfaceType.InterfaceIsIUnknown),
	GuidAttribute("bd3f23c0-d43e-11cf-893b-00aa00bdce1a")]
	public interface IDocHostUIHandler
	{
		[PreserveSig]
		uint ShowContextMenu(uint dwID, ref tagPOINT ppt,
							[MarshalAs(UnmanagedType.IUnknown)]  object pcmdtReserved,
							[MarshalAs(UnmanagedType.IDispatch)] object pdispReserved);
		[PreserveSig]
		uint GetHostInfo(ref DOCHOSTUIINFO pInfo);
		[PreserveSig]
		uint ShowUI(uint dwID, ref IOleInPlaceActiveObject pActiveObject, ref IOleCommandTarget pCommandTarget, ref IOleInPlaceFrame pFrame, ref IOleInPlaceUIWindow pDoc);
		[PreserveSig]
		uint HideUI();
		[PreserveSig]
		uint UpdateUI();
		[PreserveSig]
		uint EnableModeless([In]bool fEnable);
		[PreserveSig]
		uint OnDocWindowActivate([In]int fActivate);
		[PreserveSig]
		uint OnFrameWindowActivate([In]int fActivate);
		[PreserveSig]
		uint ResizeBorder([In]ref tagRECT prcBorder, [In]IOleInPlaceUIWindow pUIWindow, [In]bool fRameWindow);

		[PreserveSig]
		uint TranslateAccelerator(ref tagMSG lpMsg, ref Guid pguidCmdGroup, uint nCmdID);
		[PreserveSig]
		uint GetOptionKeyPath([MarshalAs(UnmanagedType.BStr)] ref string pchKey, uint dw);
		[PreserveSig]
		uint GetDropTarget(ref IOleDropTarget pDropTarget, out IOleDropTarget ppDropTarget);
		[PreserveSig]
		uint GetExternal(out object external);

		[PreserveSig]
		uint TranslateUrl(uint dwTranslate,
						  [MarshalAs(UnmanagedType.BStr)] string pchURLIn,
						  [MarshalAs(UnmanagedType.BStr)] ref string ppchURLOut);
		[PreserveSig]
		uint FilterDataObject([In]IDataObject pDO, out IDataObject ppDORet);
	}


	#region Struct

	[StructLayout(LayoutKind.Sequential)]
	public struct DOCHOSTUIINFO
	{
		public uint cbSize;
		public uint dwFlags;
		public uint dwDoubleClick;
		[MarshalAs(UnmanagedType.BStr)]
		public string pchHostCss;
		[MarshalAs(UnmanagedType.BStr)]
		public string pchHostNS;
	}

	#endregion

	#region Enums

	public enum DOCHOSTUITYPE
	{
		DOCHOSTUITYPE_BROWSE = 0,
		DOCHOSTUITYPE_AUTHOR = 1
	}

	public enum DOCHOSTUIDBLCLK
	{
		DOCHOSTUIDBLCLK_DEFAULT = 0,
		DOCHOSTUIDBLCLK_SHOWPROPERTIES = 1,
		DOCHOSTUIDBLCLK_SHOWCODE = 2
	}

	[Flags]
	public enum DOCHOSTUIFLAG
	{
		DOCHOSTUIFLAG_DIALOG = 0x00000001,
		DOCHOSTUIFLAG_DISABLE_HELP_MENU = 0x00000002,
		DOCHOSTUIFLAG_NO3DBORDER = 0x00000004,
		DOCHOSTUIFLAG_SCROLL_NO = 0x00000008,
		DOCHOSTUIFLAG_DISABLE_SCRIPT_INACTIVE = 0x00000010,
		DOCHOSTUIFLAG_OPENNEWWIN = 0x00000020,
		DOCHOSTUIFLAG_DISABLE_OFFSCREEN = 0x00000040,
		DOCHOSTUIFLAG_FLAT_SCROLLBAR = 0x00000080,
		DOCHOSTUIFLAG_DIV_BLOCKDEFAULT = 0x00000100,
		DOCHOSTUIFLAG_ACTIVATE_CLIENTHIT_ONLY = 0x00000200,
		DOCHOSTUIFLAG_OVERRIDEBEHAVIORFACTORY = 0x00000400,
		DOCHOSTUIFLAG_CODEPAGELINKEDFONTS = 0x00000800,
		DOCHOSTUIFLAG_URL_ENCODING_DISABLE_UTF8 = 0x00001000,
		DOCHOSTUIFLAG_URL_ENCODING_ENABLE_UTF8 = 0x00002000,
		DOCHOSTUIFLAG_ENABLE_FORMS_AUTOCOMPLETE = 0x00004000,
		DOCHOSTUIFLAG_ENABLE_INPLACE_NAVIGATION = 0x00010000,
		DOCHOSTUIFLAG_IME_ENABLE_RECONVERSION = 0x00020000,
		DOCHOSTUIFLAG_THEME = 0x00040000,
		DOCHOSTUIFLAG_NOTHEME = 0x00080000,
		DOCHOSTUIFLAG_NOPICS = 0x00100000,
		DOCHOSTUIFLAG_NO3DOUTERBORDER = 0x00200000,
		DOCHOSTUIFLAG_DISABLE_EDIT_NS_FIXUP = 0x400000,
		DOCHOSTUIFLAG_LOCAL_MACHINE_ACCESS_CHECK = 0x800000,
		DOCHOSTUIFLAG_DISABLE_UNTRUSTEDPROTOCOL = 0x1000000
	}

	#endregion
}
