using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace Boon
{
    /// <summary>
    /// ݒ\NXłB
    /// </summary>
    [Serializable()]
    [XmlRoot("BoonConfigSerializableRoot")]
    public class BoonSerializableConfig
    {

        /// <summary>
        /// ݒl̃ftHgl\NXłB
        /// </summary>
        private static class DefaultValue
        {
            public static readonly int startUpStatus = BoonDefine.START_UP_STATUS_OPEN_PREVIOUS_TAB;

            public static readonly string homeUrl = "http://www.nicovideo.jp";

            public static readonly string saveFolderPath = Environment.GetFolderPath(Environment.SpecialFolder.Personal);

            public static readonly int maxDownloadConnections = 1;

            public static readonly int historyExpiredDate = 14;

            public static readonly bool isAutoLoginEnabled = false;

            public static readonly string loginMailAddress = "";

            public static readonly string loginPassword = "";

            public static readonly bool isSwfPlayedOnLocalPlayer = false;

            public static readonly string swfPlayerProgram = "";

            public static readonly bool isProxyUse = true;

            public static readonly bool isDefalutProxy = true;

            public static readonly string proxyAddress = "";

            public static readonly string proxyPort = "";

            public static readonly string proxyException = "";

            public static readonly bool isLocalProxyInvokedAtStartUp = false;

            public static readonly string localProxyProgram = "";

            public static readonly int localProxyProgramInvokeWaitSeconds = 3;

            public static readonly bool isKeyAddedToFilename = false;

            public static readonly bool isAllSaveTreeExpandAtStartUp = false;

            public static readonly bool isAllColumnSelectedInDownloadList = false;

            public static readonly bool hideErrorWhileDownloading = false;

            public static readonly bool isMouseWheelEffectedUnderCursor = false;

        }

        /// <summary>
        /// ̃NXB̃IuWFNgłB
        /// </summary>
        private static BoonSerializableConfig config__ = null;

		#region Field

		/// <summary>
		/// <see cref="Boon.Control.Browsers.TabBrowserControl"/>ׂ̈̐ݒf[^łB
		/// </summary>
		private Boon.Controls.Browsers.TabBrowserSetting tabBrowserSetting_;

		/// <summary>
        /// N̓lłB
        /// </summary>
        private int startUpStatus_;

        /// <summary>
        /// z[URLłB
        /// </summary>
        private string homeUrl_;

        /// <summary>
        /// ̕ۑtH_łB
        /// </summary>
        private string saveFolderPath_;
        
        /// <summary>
        /// 
        /// </summary>
        private int maxDownloadConnections_;

        /// <summary>
        /// 
        /// </summary>
        private bool isAutoLoginEnabled_;

        /// <summary>
        /// 
        /// </summary>
        private string loginMailAddress_;

        /// <summary>
        /// 
        /// </summary>
        private string loginPassword_;

        /// <summary>
        /// 
        /// </summary>
        private bool isSwfPlayedOnLocalPlayer_;

        /// <summary>
        /// 
        /// </summary>
        private string swfPlayerProgram_;

        /// <summary>
        /// 
        /// </summary>
        private bool isProxyUse_;

        /// <summary>
        /// 
        /// </summary>
        private bool isDefaultProxy_;

        /// <summary>
        /// 
        /// </summary>
        private string proxyAddress_;

        /// <summary>
        /// 
        /// </summary>
        private string proxyPort_;

        /// <summary>
        /// 
        /// </summary>
        private string proxyException_;

        /// <summary>
        /// 
        /// </summary>
        private bool isLocalProxyInvokedAtStartUp_;

        /// <summary>
        /// 
        /// </summary>
        private string localProxyProgram_;

        /// <summary>
        /// 
        /// </summary>
        private int localProxyProgramInvokeWaitSeconds_;

        /// <summary>
        /// 
        /// </summary>
        private bool isKeyAddedToFilename_;

        /// <summary>
        /// 
        /// </summary>
        private bool isAllSaveTreeExpandAtStartUp_;
        
        /// <summary>
        /// 
        /// </summary>
        private bool isAllColumnSelectedInDownloadList_;
        
        /// <summary>
        /// 
        /// </summary>
        private bool hideErrorWhileDownloading_;
        
        /// <summary>
        /// 
        /// </summary>
        private bool isMouseWheelEffectedUnderCursor_;

        /// <summary>
        /// 
        /// </summary>
        private int historyExpiredDate_;

		#endregion

		/// <summary>
        /// RXgN^łB
        /// </summary>
        private BoonSerializableConfig()
        {
        }

        private void SetDefaultValue()
        {
			this.tabBrowserSetting_ = new Boon.Controls.Browsers.TabBrowserSetting();

            this.startUpStatus_ = DefaultValue.startUpStatus;
            this.homeUrl_ = DefaultValue.homeUrl;
            this.saveFolderPath_ = DefaultValue.saveFolderPath;
            this.maxDownloadConnections_ = DefaultValue.maxDownloadConnections;

            this.isAutoLoginEnabled_ = DefaultValue.isAutoLoginEnabled;
            this.loginMailAddress_ = DefaultValue.loginMailAddress;
            this.loginPassword_ = DefaultValue.loginPassword;

            this.isSwfPlayedOnLocalPlayer_ = DefaultValue.isSwfPlayedOnLocalPlayer;
            this.swfPlayerProgram_ = DefaultValue.swfPlayerProgram;

            this.isProxyUse_ = DefaultValue.isProxyUse;
            this.isDefaultProxy_ = DefaultValue.isDefalutProxy;
            this.proxyAddress_ = DefaultValue.proxyAddress;
            this.proxyPort_ = DefaultValue.proxyPort;
            this.proxyException_ = DefaultValue.proxyException;
            this.isLocalProxyInvokedAtStartUp_ = DefaultValue.isLocalProxyInvokedAtStartUp;
            this.localProxyProgram_ = DefaultValue.localProxyProgram;
            this.localProxyProgramInvokeWaitSeconds_ = DefaultValue.localProxyProgramInvokeWaitSeconds;

            this.isKeyAddedToFilename_ = DefaultValue.isKeyAddedToFilename;
            this.isAllSaveTreeExpandAtStartUp_ = DefaultValue.isAllSaveTreeExpandAtStartUp;
            this.isAllColumnSelectedInDownloadList_ = DefaultValue.isAllColumnSelectedInDownloadList;
            this.hideErrorWhileDownloading_ = DefaultValue.hideErrorWhileDownloading;
            this.isMouseWheelEffectedUnderCursor_ = DefaultValue.isMouseWheelEffectedUnderCursor;
            this.historyExpiredDate_ = DefaultValue.historyExpiredDate;
        }

        /// <summary>
        /// ̃NX̗B̃IuWFNg擾܂B
        /// </summary>
        /// <returns></returns>
        public static BoonSerializableConfig getInstance()
        {
            if (BoonSerializableConfig.config__ == null)
            {
                BoonSerializableConfig.config__ = new BoonSerializableConfig();
                BoonSerializableConfig.config__.deserializeConfigValue();
            }

            return (BoonSerializableConfig.config__);
        }

        /// <summary>
        /// IuWFNgVACY܂B
        /// JgtH_Ƀt@C܂B
        /// </summary>
        public void serializeConfigValue()
        {
            XmlSerializer serializer = new XmlSerializer(typeof(BoonSerializableConfig), new XmlRootAttribute("BoonConfigSerializableRoot"));
            try
            {
                using (FileStream fs = new FileStream(Application.StartupPath + @"\boonConfig.xml", FileMode.Create))
                {
                    serializer.Serialize(fs, this);
                    fs.Close();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
        }

        /// <summary>
        /// IuWFNgt@CfVACY܂B
        /// </summary>
        public void deserializeConfigValue()
        {
            try
            {
				string configpath = Application.StartupPath + @"\boonConfig.xml";
                if (File.Exists(configpath))
                {
                    XmlSerializer serializer = new XmlSerializer(typeof(BoonSerializableConfig), new XmlRootAttribute("BoonConfigSerializableRoot"));
                    FileStream fs = new FileStream(configpath, FileMode.Open);
                    BoonSerializableConfig.config__ = (BoonSerializableConfig)serializer.Deserialize(fs);
                    fs.Close();
                }
                else
                {
                    this.SetDefaultValue();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
		}

		#region Properties

		/// <summary>
		/// <see cref="Boon.Control.Browsers.TabBrowserControl"/>ׂ̈̐ݒf[^擾Eݒ肵܂B
		/// </summary>
		public Boon.Controls.Browsers.TabBrowserSetting TabBrowserSetting
		{
			get { return this.tabBrowserSetting_; }
			set { this.tabBrowserSetting_ = value; }
		}

		/// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "startUpStatus", IsNullable = false)]
        public int startUpStatus
        {
            get
            {
                return (this.startUpStatus_);
            }

            set
            {
                this.startUpStatus_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "homeUrl", IsNullable = false)]
        public string homeUrl
        {
            get
            {
                return (this.homeUrl_);
            }

            set
            {
                this.homeUrl_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "saveFolderPath", IsNullable = false)]
        public string saveFolderPath
        {
            get
            {
                return (this.saveFolderPath_);
            }

            set
            {
                this.saveFolderPath_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "maxDownloadConnections", IsNullable = false)]
        public int maxDownloadConnections
        {
            get
            {
                return (this.maxDownloadConnections_);
            }

            set
            {
                if (value < 0)
                {
                    this.maxDownloadConnections_ = 0;
                }
                else if (value > 2)
                {
                    this.maxDownloadConnections_ = 2;
                }
                else
                {
                    this.maxDownloadConnections_ = value;
                }
            }
        }


        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isAutoLoginEnabled", IsNullable = false)]
        public bool isAutoLoginEnabled
        {
            get
            {
                return (this.isAutoLoginEnabled_);
            }

            set
            {
                this.isAutoLoginEnabled_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "loginMailAddress", IsNullable = false)]
        public string loginMailAddress
        {
            get
            {
                return (this.loginMailAddress_);
            }

            set
            {
                this.loginMailAddress_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "loginPassword", IsNullable = false)]
        public string loginPassword
        {
            get
            {
                return (this.loginPassword_);
            }

            set
            {
                this.loginPassword_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isSwfPlayedOnLocalPlayer", IsNullable = false)]
        public bool isSwfPlayedOnLocalPlayer
        {
            get
            {
                return (this.isSwfPlayedOnLocalPlayer_);
            }

            set
            {
                this.isSwfPlayedOnLocalPlayer_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "swfPlayerProgram", IsNullable = false)]
        public string swfPlayerProgram
        {
            get
            {
                return (this.swfPlayerProgram_);
            }

            set
            {
                this.swfPlayerProgram_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isProxyUse", IsNullable = false)]
        public bool isProxyUse
        {
            get
            {
                return (this.isProxyUse_);
            }

            set
            {
                this.isProxyUse_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isDefaultProxy", IsNullable = false)]
        public bool isDefaultProxy
        {
            get
            {
                return (this.isDefaultProxy_);
            }

            set
            {
                this.isDefaultProxy_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "proxyAddress", IsNullable = false)]
        public string proxyAddress
        {
            get
            {
                return (this.proxyAddress_);
            }

            set
            {
                this.proxyAddress_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "proxyPort", IsNullable = false)]
        public string proxyPort
        {
            get
            {
                return (this.proxyPort_);
            }

            set
            {
                if (("".Equals(value) || (System.Text.RegularExpressions.Regex.IsMatch(value, "[^0-9]"))))
                {
                    return;
                }

                int p = int.Parse(value);

                if ((p < 0) || (p > 65535)) return;

                this.proxyPort_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "proxyException", IsNullable = false)]
        public string proxyException
        {
            get
            {
                return (this.proxyException_);
            }

            set
            {
                this.proxyException_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isLocalProxyInvokedAtStartUp", IsNullable = false)]
        public bool isLocalProxyInvokedAtStartUp
        {
            get
            {
                return (this.isLocalProxyInvokedAtStartUp_);
            }

            set
            {
                this.isLocalProxyInvokedAtStartUp_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "localProxyProgram", IsNullable = false)]
        public string localProxyProgram
        {
            get
            {
                return (this.localProxyProgram_);
            }

            set
            {
                this.localProxyProgram_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "localProxyProgramInvokeWaitSeconds", IsNullable = false)]
        public int localProxyProgramInvokeWaitSeconds
        {
            get
            {
                return (this.localProxyProgramInvokeWaitSeconds_);
            }

            set
            {
                if (value < 1)
                {
                    this.localProxyProgramInvokeWaitSeconds_ = 1;
                }
                else if (value > 99)
                {
                    this.localProxyProgramInvokeWaitSeconds_ = 99;
                }
                else
                {
                    this.localProxyProgramInvokeWaitSeconds_ = value;
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isKeyAddedToFilename", IsNullable = false)]
        public bool isKeyAddedToFilename
        {
            get
            {
                return (this.isKeyAddedToFilename_);
            }

            set
            {
                this.isKeyAddedToFilename_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName="isAllSaveTreeExpandAtStartUp", IsNullable=false)]
        public bool isAllSaveTreeExpandAtStartUp
        {
            get
            {
                return (this.isAllSaveTreeExpandAtStartUp_);
            }

            set
            {
                this.isAllSaveTreeExpandAtStartUp_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isAllColumnSelectedInDownloadList", IsNullable = false)]
        public bool isAllColumnSelectedInDownloadList
        {
            get
            {
                return (this.isAllColumnSelectedInDownloadList_);
            }

            set
            {
                this.isAllColumnSelectedInDownloadList_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "hideErrorWhileDownloading", IsNullable = false)]
        public bool hideErrorWhileDownloading
        {
            get
            {
                return (this.hideErrorWhileDownloading_);
            }

            set
            {
                this.hideErrorWhileDownloading_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "isMouseWheelEffectedUnderCursor", IsNullable = false)]
        public bool isMouseWheelEffectedUnderCursor
        {
            get
            {
                return (this.isMouseWheelEffectedUnderCursor_);
            }

            set
            {
                this.isMouseWheelEffectedUnderCursor_ = value;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        [XmlElement(ElementName = "historyExpiredDate", IsNullable = false)]
        public int historyExpiredDate
        {
            get
            {
                return (this.historyExpiredDate_);
            }

            set
            {
                if (value < 1)
                {
                    this.historyExpiredDate_ = 1;
                }
                else if (value > 999)
                {
                    this.historyExpiredDate_ = 999;
                }
                else
                {
                    this.historyExpiredDate_ = value;
                }
            }
		}

		#endregion

		/// <summary>
        /// 
        /// </summary>
        [XmlAnyElement()]
        public XmlElement[] Any;



    }
}
