﻿/*
 * SingerConfig.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if __cplusplus
#else
using System;
using System.IO;
using System.Collections.Generic;
#endif

#if __cplusplus
namespace Boare{ namespace Lib{ namespace Vsq{
#else
namespace Boare.Lib.Vsq {
#endif

#if __cplusplus
    class SingerConfig{
#else
    public class SingerConfig {
#endif
        string m_id;
        string m_format;
        string m_voiceidstr;
        string m_voicename;
        int m_breathiness;
        int m_brightness;
        int m_clearness;
        int m_opening;
        int m_gender_factor;
        int m_original;

#if __cplusplus
    public: 
        static void decode_vvd_bytes( vector<byte> dat ){
            for ( int i = 0; i < dat.size(); i++ ) {
#else
        public static void decode_vvd_bytes( ref byte[] dat ) {
            for ( int i = 0; i < dat.Length; i++ ) {
#endif
                byte M = (byte)(dat[i] >> 4);
                byte L = (byte)(dat[i] - (M << 4));
                byte newM = endecode_vvd_m( M );
                byte newL = endecode_vvd_l( L );
                dat[i] = (byte)((newM << 4) | newL);
            }
        }

        static byte endecode_vvd_l( byte value ) {
            switch ( value ) {
                case 0x0:
                    return 0xa;
                case 0x1:
                    return 0xb;
                case 0x2:
                    return 0x8;
                case 0x3:
                    return 0x9;
                case 0x4:
                    return 0xe;
                case 0x5:
                    return 0xf;
                case 0x6:
                    return 0xc;
                case 0x7:
                    return 0xd;
                case 0x8:
                    return 0x2;
                case 0x9:
                    return 0x3;
                case 0xa:
                    return 0x0;
                case 0xb:
                    return 0x1;
                case 0xc:
                    return 0x6;
                case 0xd:
                    return 0x7;
                case 0xe:
                    return 0x4;
                case 0xf:
                    return 0x5;
            }
            return 0x0;
        }

        static byte endecode_vvd_m( byte value ) {
            switch ( value ) {
                case 0x0:
                    return 0x1;
                case 0x1:
                    return 0x0;
                case 0x2:
                    return 0x3;
                case 0x3:
                    return 0x2;
                case 0x4:
                    return 0x5;
                case 0x5:
                    return 0x4;
                case 0x6:
                    return 0x7;
                case 0x7:
                    return 0x6;
                case 0x8:
                    return 0x9;
                case 0x9:
                    return 0x8;
                case 0xa:
                    return 0xb;
                case 0xb:
                    return 0xa;
                case 0xc:
                    return 0xd;
                case 0xd:
                    return 0xc;
                case 0xe:
                    return 0xf;
                case 0xf:
                    return 0xe;
            }
            return 0x0;
        }

#if __cplusplus
    public:
        SingerConfig( string file, int original ) 
            : Original( this,     &SingerConfig::getOriginal,     &SingerConfig::setOriginal ),
              ID( this,           &SingerConfig::getID,           &SingerConfig::setID ),
              FORMAT( this,       &SingerConfig::getFORMAT,       &SingerConfig::setFORMAT ),
              VOICEIDSTR( this,   &SingerConfig::getVOICEIDSTR,   &SingerConfig::setVOICEIDSTR ),
              VOICENAME( this,    &SingerConfig::getVOICENAME,    &SingerConfig::setVOICENAME ),
              Breathiness( this,  &SingerConfig::getBreathiness,  &SingerConfig::setBreathiness ),
              Brightness( this,   &SingerConfig::getBrightness,   &SingerConfig::setBrightness ),
              Clearness( this,    &SingerConfig::getClearness,    &SingerConfig::setClearness ),
              Opening( this,      &SingerConfig::getOpening,      &SingerConfig::setOpening ),
              GenderFactor( this, &SingerConfig::getGenderFactor, &SingerConfig::setGenderFactor )
        {
#else
        public SingerConfig( string file, int original ) {
#endif
            m_original = original;
            m_id = "VOCALOID:VIRTUAL:VOICE";
            m_format = "2.0.0.0";
            m_voiceidstr = "";
            m_voicename = "Miku";
            m_breathiness = 0;
            m_brightness = 0;
            m_clearness = 0;
            m_opening = 0;
            m_gender_factor = 0;
            m_original = 0;
#if __cplusplus
            std::ifstream fs;
#else
            FileStream fs = null;
#endif
            try {
#if __cplusplus
                fs.open( file.c_str(), std::ios_base::in );
                fs.peek();
                int length = fs.rdbuf()->in_avail();
                byte *bdat = new byte[length];
                fs.read( (char *)bdat, length );
                vector<byte> dat( length );
                for( int i = 0; i < length; i++ ){
                    dat[i] = bdat[i];
                }
                delete [] bdat;
                decode_vvd_bytes( dat );
                for ( int i = 0; i < dat.size() - 1; i++ ) {
#else
                fs = new FileStream( file, FileMode.Open, FileAccess.Read );
                int length = (int)fs.Length;
                byte[] dat = new byte[length];
                fs.Read( dat, 0, length );
                decode_vvd_bytes( ref dat );
                for ( int i = 0; i < dat.Length - 1; i++ ) {
#endif
                    if ( dat[i] == 0x17 && dat[i + 1] == 0x10 ) {
                        dat[i] = 0x0d;
                        dat[i + 1] = 0x0a;
                    }
                }
#if __cplusplus
                string str = bocoree::cp932::convert( dat );
                string crlf = ((char)0x0d) + "" + (char)0x0a;
#else
                string str = bocoree.cp932.convert( dat );
                string crlf = ((char)0x0d).ToString() + ((char)0x0a).ToString();
#endif
#if __cplusplus
                vector<string> spl = util_split( str, crlf );
#else
                string[] spl = str.Split( new string[] { crlf }, StringSplitOptions.RemoveEmptyEntries );
#endif

#if __cplusplus
                for( int i = 0; i < spl.size(); i++ ){
                    string s = spl[i];
                    int first = s.find( "\"" );
#else
                foreach ( string s in spl ) {
                    int first = s.IndexOf( '"' );
#endif
                    int first_end = get_quated_string( s, first );
#if __cplusplus
                    int second = s.find( "\"", first_end + 1 );
#else
                    int second = s.IndexOf( '"', first_end + 1 );
#endif
                    int second_end = get_quated_string( s, second );
#if __cplusplus
                    vector<wchar_t> chs = util_string_to_array( s );
                    string id = util_string_from_array( chs, first, first_end - first + 1 );
                    string value = util_string_from_array( chs, second, second_end - second + 1 );
                    id = id.substr( 1, id.size() - 2 );
                    value = value.substr( 1, value.size() - 2 );
                    value = value.replace( "\\\"", "\"" ); //無いのかOTL
#else
                    char[] chs = s.ToCharArray();
                    string id = new string( chs, first, first_end - first + 1 );
                    string value = new string( chs, second, second_end - second + 1 );
                    id = id.Substring( 1, id.Length - 2 );
                    value = value.Substring( 1, value.Length - 2 );
                    value = value.Replace( "\\\"", "\"" );
#endif
                    if ( id == "ID" ) {
                        m_id = value;
                    } else if ( id == "FORMAT" ) {
                        m_format = value;
                    } else if ( id == "VOICEIDSTR" ) {
                        m_voiceidstr = value;
                    } else if ( id == "VOICENAME" ) {
                        m_voicename = value;
                    } else if ( id == "Breathiness" ) {
                        try {
                            m_breathiness = int.Parse( value );
                        } catch {
                        }
                    } else if ( id == "Brightness" ) {
                        try {
                            m_brightness = int.Parse( value );
                        } catch {
                        }
                    } else if ( id == "Clearness" ) {
                        try {
                            m_clearness = int.Parse( value );
                        } catch {
                        }
                    } else if ( id == "Opening" ) {
                        try {
                            m_opening = int.Parse( value );
                        } catch {
                        }
                    } else if ( id == "Gender:Factor" ) {
                        try {
                            m_gender_factor = int.Parse( value );
                        } catch {
                        }
                    }
                }
            } catch {

            } finally {
#if __cplusplus
                if( fs.is_open() ){
                    fs.close();
                }
#else
                if ( fs != null ) {
                    fs.Close();
                }
#endif
            }
        }

        /// <summary>
        /// 位置positionにある'"'から，次に現れる'"'の位置を調べる．エスケープされた\"はスキップされる．'"'が見つからなかった場合-1を返す
        /// </summary>
        /// <param name="s"></param>
        /// <param name="position"></param>
        /// <returns></returns>
        static int get_quated_string( string s, int position ) {
            if ( position < 0 ) {
                return -1;
            }
            char[] chs = s.ToCharArray();
            if ( position >= chs.Length ) {
                return -1;
            }
            if ( chs[position] != '"' ) {
                return -1;
            }
            int end = -1;
            for ( int i = position + 1; i < chs.Length; i++ ) {
                if ( chs[i] == '"' && chs[i - 1] != '\\' ) {
                    end = i;
                    break;
                }
            }
            return end;
        }

#if __cplusplus
    public:
        vector<string> ToString() {
            vector<string> ret = new vector<string>( 0 );
            ret.push_back( "\"ID\":=:\"" + m_id + "\"" );
            ret.push_back( "\"FORMAT\":=:\"" + m_format + "\"" );
            ret.push_back( "\"VOICEIDSTR\":=:\"" + m_voiceidstr + "\"" );
            ret.push_back( "\"VOICENAME\":=:\"" + m_voicename.Replace( "\"", "\\\"" ) + "\"" );
            ret.push_back( "\"Breathiness\":=:\"" + m_breathiness + "\"" );
            ret.push_back( "\"Brightness\":=:\"" + m_brightness + "\"" );
            ret.push_back( "\"Clearness\":=:\"" + m_clearness + "\"" );
            ret.push_back( "\"Opening\":=:\"" + m_opening + "\"" );
            ret.push_back( "\"Gender:Factor\":=:\"" + m_gender_factor + "\"" );
            return ret;
        }
#else
        public new string[] ToString() {
            List<string> ret = new List<string>();
            ret.Add( "\"ID\":=:\"" + m_id + "\"" );
            ret.Add( "\"FORMAT\":=:\"" + m_format + "\"" );
            ret.Add( "\"VOICEIDSTR\":=:\"" + m_voiceidstr + "\"" );
            ret.Add( "\"VOICENAME\":=:\"" + m_voicename.Replace( "\"", "\\\"" ) + "\"" );
            ret.Add( "\"Breathiness\":=:\"" + m_breathiness + "\"" );
            ret.Add( "\"Brightness\":=:\"" + m_brightness + "\"" );
            ret.Add( "\"Clearness\":=:\"" + m_clearness + "\"" );
            ret.Add( "\"Opening\":=:\"" + m_opening + "\"" );
            ret.Add( "\"Gender:Factor\":=:\"" + m_gender_factor + "\"" );
            return ret.ToArray();
        }
#endif

#if __cplusplus
    public:
        Property<SingerConfig, int> Original;
#else
        public int Original {
            get {
                return getOriginal();
            }
            set{
                setOriginal( value );
            }
        }
#endif
        int getOriginal(){
            return m_original;
        }

        void setOriginal( int value ){
            m_original = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, string> ID;
#else
        public string ID{
            get{
                return getID();
            }
            set{
                setID( value );
            }
        }
#endif
        string getID(){
            return m_id;
        }

        void setID( string value ){
            m_id = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, string> FORMAT;
#else
        public string FORMAT{
            get{
                return getFORMAT();
            }
            set{
                setFORMAT( value );
            }
        }
#endif
        string getFORMAT(){
            return m_format;
        }

        void setFORMAT( string value ){
            m_format = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, string> VOICEIDSTR;
#else
        public string VOICEIDSTR{
            get{
                return getVOICEIDSTR();
            }
            set{
                setVOICEIDSTR( value );
            }
        }
#endif
        string getVOICEIDSTR(){
            return m_voiceidstr;
        }

        void setVOICEIDSTR( string value ){
            m_voiceidstr = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, string> VOICENAME;
#else
        public string VOICENAME {
            get {
                return getVOICENAME();
            }
            set {
                setVOICENAME( value );
            }
        }
#endif
        string getVOICENAME(){
            return m_voicename;
        }

        void setVOICENAME( string value ){
            m_voicename = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, int> Breathiness;
#else
        public int Breathiness {
            get {
                return getBreathiness();
            }
            set {
                setBreathiness( value );
            }
        }
#endif
        int getBreathiness(){
            return m_breathiness;
        }

        void setBreathiness( int value ){
            m_breathiness = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, int> Brightness;
#else
        public int Brightness {
            get {
                return getBrightness();
            }
            set {
                setBrightness( value );
            }
        }
#endif
        int getBrightness(){
            return m_brightness;
        }

        void setBrightness( int value ){
            m_brightness = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, int> Clearness;
#else
        public int Clearness {
            get {
                return getClearness();
            }
            set {
                setClearness( value );
            }
        }
#endif
        int getClearness(){
            return m_clearness;
        }
        
        void setClearness( int value ){
            m_clearness = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, int> Opening;
#else
        public int Opening {
            get {
                return getOpening();
            }
            set {
                setOpening( value );
            }
        }
#endif
        int getOpening(){
            return m_opening;
        }

        void setOpening( int value ){
            m_opening = value;
        }

#if __cplusplus
    public:
        Property<SingerConfig, int> GenderFactor;
#else
        public int GenderFactor {
            get {
                return getGenderFactor();
            }
            set {
                setGenderFactor( value );
            }
        }
#endif
        int getGenderFactor(){
            return m_gender_factor;
        }

        void setGenderFactor( int value ){
            m_gender_factor = value;
        }
    };
#if __cplusplus
} } }
#else
}
#endif
