﻿/*
 * TextMemoryStream.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

using bocoree;

namespace Boare.Lib.Vsq {

    public class TextMemoryStream : IDisposable {
        private static readonly String NL = (char)0x0d + "" + (char)0x0a;

        private Vector<String> m_lines;
        private int m_index;

        public TextMemoryStream() {
            m_lines = new Vector<String>();
            m_lines.add( "" );
            m_index = 0;
        }

        public TextMemoryStream( String path, Encoding encoding ) {
            m_lines = new Vector<String>();
            m_index = 0;
            if ( File.Exists( path ) ) {
                using ( StreamReader sr = new StreamReader( path, encoding ) ) {
                    while ( sr.Peek() >= 0 ) {
                        String line = sr.ReadLine();
                        m_lines.add( line );
                        m_index++;
                    }
                }
            }
        }

        public void write( String value ) {
            appendString( value );
        }

        public void writeLine( String value ) {
            appendString( value + NL );
        }

        private void appendString( String value ) {
            String[] lines = value.Split( new String[] { NL }, StringSplitOptions.None );
            Vector<String> lines2 = new Vector<String>();
            for ( int i = 0; i < lines.Length; i++ ) {
                String[] spl = lines[i].Split( (char)0x0d, (char)0x0a );
                for ( int j = 0; j < spl.Length; j++ ) {
                    lines2.add( spl[j] );
                }
            }
            int count = lines2.size();
            if ( count > 0 ) {
                m_lines.set( m_index, m_lines.get( m_index ) + lines2.get( 0 ) );
                for ( int i = 1; i < count; i++ ) {
                    m_lines.add( lines2.get( i ) );
                    m_index++;
                }
            }
        }

        public void rewind() {
            m_index = 0;
        }

        public String readLine() {
            m_index++;
            return m_lines.get( m_index - 1 );
        }

        public int peek() {
            if ( m_index < m_lines.size() ) {
                if ( m_lines.get( m_index ).Equals( "" ) ) {
                    return -1;
                } else {
                    return (int)m_lines.get( m_index )[0];
                }
            } else {
                return -1;
            }
        }

        public void close() {
            m_lines.clear();
        }

        public void Dispose() {
            close();
        }
    }

}
