﻿/*
 * BPPair.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if !__cplusplus
using System;
#endif

#if __cplusplus
namespace Boare{ namespace Lib{ namespace Vsq{
#else
namespace Boare.Lib.Vsq {
#endif

    /// <summary>
    /// Stores the paired value of "Clock" and integer. Mainly used in VsqBPList
    /// </summary>
#if __cplusplus
    class BPPair{
#else
    [Serializable]
    public class BPPair : IComparable<BPPair> {
#endif
#if __cplusplus
        public int Clock;
        public int Value;
#else
        private int m_clock;
        private int m_value;
#endif

        /// <summary>
        /// このインスタンスと、指定したオブジェクトを比較します
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public int CompareTo( BPPair item ) {
            if ( Clock > item.Clock ) {
                return 1;
            } else if ( Clock < item.Clock ) {
                return -1;
            } else {
                return 0;
            }
        }

#if !__cplusplus
        /// <summary>
        /// Gets or Sets Clock
        /// </summary>
        public int Clock {
            get {
                return m_clock;
            }
            set {
                m_clock = value;
            }
        }
#endif

#if !__cplusplus
        /// <summary>
        /// Gets or Sets the Value
        /// </summary>
        public int Value {
            get {
                return m_value;
            }
            set {
                m_value = value;
            }
        }
#endif

        public BPPair( int clock, int value ) {
            Clock = clock;
            Value = value;
        }
    };

#if __cplusplus
} } }
#else
}
#endif
