#include "common.h"

namespace Boare{ namespace Lib{ namespace Vsq{

vector<string> split( string str, string delim ){
    vector<string> result;
    int cutAt;
    while( (cutAt = str.find_first_of( delim )) != str.npos ){
        if( cutAt > 0 ){
            result.push_back( str.substr( 0, cutAt ) );
        }
        str = str.substr( cutAt + 1 );
    }
    if( str.length() > 0 ){
        result.push_back( str );
    }
    return result;
}

int int_parse( string str ){
    istringstream s( str );
    int ret = 0;
    s >> ret;
    return ret;
}

StreamReader_t::StreamReader_t( string path ){
    m_ifs.open( path.c_str() );
}

void StreamReader::Close(){
    m_ifs.close();
}

string StreamReader::ReadLine(){
    string ret;
    if( get_line( &m_ifs, &ret ) ){
        return ret;
    }else{
        return NULL;
    }
}

int StreamReader::Peek(){
    return m_ifs.peek();
}

bool StreamReader::get_line( ifstream *ifs, string *str ){
    char ch;
    if( ifs->eof() ){
        return false;
    }
    while( ifs->get( ch ) ){
        if( ch == 0x0d ){
            if( ifs->get( ch ) ){
                if( ch != 0x0a ){
                    ifs->seekg( -1, ios::cur );
                }
            }
            break;
        }else if( ch == 0x0a ){
            break;
        }
        str->append( 1, ch );
    }
    return true;
}

} } }
