﻿/*
 * FormCompileResult.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace Boare.Cadencii {

    public partial class FormCompileResult : Form {
        public FormCompileResult( string message, string errors ) {
            InitializeComponent();
            ApplyLanguage();
            label1.Text = message;
            textBox1.Text = errors;
            Misc.ApplyFontRecurse( this, AppManager.EditorConfig.BaseFont );
        }

        public void ApplyLanguage() {
            this.textBox1.Text = _( "Script Compilation Result" );
        }

        private static string _( string id ) {
            return Messaging.GetMessage( id );
        }
    }

}
