﻿/*
 * ExpressionConfigSys.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package com.boare.vsq;
#else
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

using bocoree;

namespace Boare.Lib.Vsq {
#endif

    public class ExpressionConfigSys {
        private const int MAX_VIBRATO = 0x400;
        private Vector<VibratoConfig> m_vibrato_configs;
        private Vector<AttackConfig> m_attack_configs;

        public ExpressionConfigSys( String path_expdb ) {
            m_vibrato_configs = new Vector<VibratoConfig>();
            m_attack_configs = new Vector<AttackConfig>();
            String expression = Path.Combine( path_expdb, "expression.map" );
            if ( !File.Exists( expression ) ) {
                return;
            }

            FileStream fs = null;
            try {
                new FileStream( expression, FileMode.Open, FileAccess.Read );
                byte[] dat = new byte[8];
                fs.Seek( 0x20, SeekOrigin.Begin );
                for ( int i = 0; i < MAX_VIBRATO; i++ ) {
                    fs.Read( dat, 0, 8 );
                    ulong value = VocaloSysUtil.makelong_le( dat );

                    if ( value <= 0 ) {
                        continue;
                    }

                    String ved = Path.Combine( path_expdb, "vexp" + value + ".ved" );
                    if ( !File.Exists( ved ) ) {
                        continue;
                    }
                    String vexp_dir = Path.Combine( path_expdb, "vexp" + value );
                    if ( !Directory.Exists( vexp_dir ) ) {
                        continue;
                    }

                    String NL = (char)0x0D + "" + (char)0x0A;
                    FileStream fs_ved = null;
                    try {
                        fs_ved = new FileStream( ved, FileMode.Open, FileAccess.Read );
                        byte[] byte_ved = new byte[fs_ved.Length];
                        fs_ved.Read( byte_ved, 0, byte_ved.Length );
                        TransCodeUtil.decodeBytes( ref byte_ved );
                        String str = new String( Encoding.ASCII.GetChars( byte_ved ) );
                        String[] spl = str.Split( new String[] { NL }, StringSplitOptions.RemoveEmptyEntries );
                        String current_entry = "";
                        for ( int j = 0; j < spl.Length; j++ ) {
                            if ( spl[j].StartsWith( "[" ) ) {
                                current_entry = spl[j];
                                continue;
                            } else if ( spl[j].Equals( "" ) ) {
                                continue;
                            }
                            if ( current_entry.Equals( "[VIBRATO]" ) ) {
                                String[] spl2 = spl[j].Split( ',' );
                                if ( spl2.Length < 6 ) {
                                    continue;
                                }
                                // ex: 1,1,"normal","normal2_type1.aic","[Normal]:Type:1","Standard","YAMAHA",0
                                VibratoConfig item = new VibratoConfig();
                                item.number = int.Parse( spl2[0] );
                                item.contents.IDS = spl2[2].Replace( "\"", "" );
                                item.file = spl2[3].Replace( "\"", "" );
                                item.contents.Caption = spl2[4].Replace( ":", " " ).Replace( "\"", "" );
                                item.author = spl2[5].Replace( "\"", "" );
                                item.vendor = spl2[6].Replace( "\"", "" );
                                String aic_file = Path.Combine( vexp_dir, item.file );
                                if ( !File.Exists( aic_file ) ) {
                                    continue;
                                }
                                item.parseAic( aic_file );
                            } if ( current_entry.Equals( "[NOTEATTACK]" ) ) {
                                String[] spl2 = spl[j].Split( ',' );
                                if ( spl2.Length < 6 ) {
                                    continue;
                                }
                                // ex: 1,1,"normal","normal2_type1.aic","[Normal]:Type:1","Standard","YAMAHA",0
                                AttackConfig item = new AttackConfig();
                                item.number = int.Parse( spl2[0] );
                                item.contents.IDS = spl2[2].Replace( "\"", "" );
                                item.file = spl2[3].Replace( "\"", "" );
                                item.contents.Caption = spl2[4].Replace( ":", " " ).Replace( "\"", "" );
                                item.author = spl2[5].Replace( "\"", "" );
                                item.vendor = spl2[6].Replace( "\"", "" );
                                String aic_file = Path.Combine( vexp_dir, item.file );
                                if ( !File.Exists( aic_file ) ) {
                                    continue;
                                }
                                item.parseAic( aic_file );
                            }
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( fs_ved != null ) {
                            try {
                                fs_ved.Close();
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                }
            } catch ( Exception ex ) {
            } finally {
                if ( fs != null ) {
                    try {
                        fs.Close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }
    }

}
