#ifndef PHONEMETABLEVIEW_H
#define PHONEMETABLEVIEW_H

#include <QMainWindow>
#include "analysiswindow.h"

namespace Ui {
    class phonemeTableView;
}

class phonemeTableView : public QMainWindow
{
    Q_OBJECT

public:
    explicit phonemeTableView(QWidget *parent = 0);
    ~phonemeTableView();

public slots:
    void makeSureExit(void);
    void openSetting(void);
    void importSetting(void);
    void waveScaleChange(int);
    void enableAnalysis(bool);
    void analyze(void);
    void selectKey(void);
    void generateAll(void);

private:
    Ui::phonemeTableView *ui;
    QString getSettingFilePath(void);
    void saveAll(QString &directoryPath);

    QString sourcePath;
    QString additionalPath;
    analysisWindow *analysisViewer;

private slots:
    void on_action_Import_triggered();
    void on_action_Open_triggered();
    void on_action_Exit_triggered();

signals:
    // これは仕方無いかもね．
    void settingPathOpened(QString *);
    void settingPathImported(QString *);
    void scaleChange(double);

};

#endif // PHONEMETABLEVIEW_H
