#include "VSQHandleParseContext.h"

VSQHandleParseContext::VSQHandleParseContext(){
    Reset();
}

void VSQHandleParseContext::Reset(){
    mRateBPX = "";
    mRateBPY = "";
    mDepthBPX = "";
    mDepthBPY = "";
}

bool VSQHandleParseContext::ParseVibratoDepth( NoteEvent *pEditTarget ){
    if( mDepthBPX.size() == 0 || mDepthBPY.size() == 0 ){
        return false;
    }
    return ParseVibrato( pEditTarget, mDepthBPX, mDepthBPY, true );
}

bool VSQHandleParseContext::ParseVibratoRate( NoteEvent *pEditTarget ){
    if( mRateBPX.size() == 0 || mRateBPY.size() == 0 ){
        return false;
    }
    return ParseVibrato( pEditTarget, mRateBPX, mRateBPY, false );
}

bool VSQHandleParseContext::ParseVibrato( NoteEvent *pEditTarget, string bpx, string bpy, bool parse_depth ){
    string::size_type indx_x = bpx.find( "," );
    string::size_type indx_y = bpy.find( "," );
    while( indx_x != string::npos && indx_y != string::npos ){
        double x = atof( bpx.substr( 0, indx_x ).c_str() );
        long nTick = (long)(x * (double)(pEditTarget->mLength - pEditTarget->mVibratoDelay)) + pEditTarget->mVibratoDelay;
        int iValue = atoi( bpy.substr( 0, indx_y ).c_str() );
        if( parse_depth ){
            pEditTarget->mVibratoDepth.SetValue( nTick, iValue );
        }else{
            pEditTarget->mVibratoRate.SetValue( nTick, iValue );
        }
        bpx = bpx.substr( indx_x + 1 );
        bpy = bpy.substr( indx_y + 1 );
        indx_x = bpx.find( "," );
        indx_y = bpy.find( "," );
    }
    double x = atof( bpx.c_str() );
    long nTick =(long)(x * (double)(pEditTarget->mLength - pEditTarget->mVibratoDelay)) + pEditTarget->mVibratoDelay;
    int iValue = atoi( bpy.c_str() );
    pEditTarget->mVibratoDepth.SetValue( nTick, iValue );

    return true; //いつでもtrueとか意味ないna
}
