unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  System.Actions, FMX.ActnList, FMX.StdActns, FMX.MediaLibrary.Actions,
  FMX.Media, FMX.Objects, FMX.Ani;

type
  TForm1 = class(TForm)
    CameraComponent1: TCameraComponent;
    Image1: TImage;
    Button2: TButton;
    Circle1: TCircle;
    FloatAnimation1: TFloatAnimation;
    CameraComponent2: TCameraComponent;
    procedure Button2Click(Sender: TObject);
    procedure CameraComponent1SampleBufferReady(Sender: TObject;
      const ATime: Int64);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CameraComponent2SampleBufferReady(Sender: TObject;
      const ATime: Int64);
  private
    { private 錾 }
  public
    { public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses Unit2, DateUtils;

var
  th: TCamThread;

procedure TForm1.Button2Click(Sender: TObject);
begin
  th := TCamThread.Create;
  FloatAnimation1.Start;
end;

procedure TForm1.CameraComponent1SampleBufferReady(Sender: TObject;
  const ATime: Int64);
begin
  CameraComponent1.SampleBufferToBitmap(Image1.Bitmap, true);
end;

procedure TForm1.CameraComponent2SampleBufferReady(Sender: TObject;
  const ATime: Int64);
var
  s: string;
  a, b, c, d, e, dd, hh, mm: Word;
begin
  if Active = true then
  begin
    Active := false;
    CameraComponent2.SampleBufferToBitmap(Image1.Bitmap, true);
    DecodeDateTime(Now, a, b, dd, hh, d, e, mm);
    s := ExtractFilePath(ParamStr(0)) + Format('%d_%d_%d', [dd, hh, mm]);
    Image1.Bitmap.SaveToFile(s + '.jpg');
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  CameraComponent1.Quality := TVideoCaptureQuality.LowQuality;
  CameraComponent2.Quality := TVideoCaptureQuality.HighQuality;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  CameraComponent1.Active := false;
end;

end.
