unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  System.Actions, FMX.ActnList, FMX.StdActns, FMX.MediaLibrary.Actions,
  FMX.Media, FMX.Objects, FMX.Ani;

type
  TStandby = (ready, push, shot, keep);

  TForm1 = class(TForm)
    CameraComponent1: TCameraComponent;
    Image1: TImage;
    Button2: TButton;
    Circle1: TCircle;
    FloatAnimation1: TFloatAnimation;
    procedure Button2Click(Sender: TObject);
    procedure CameraComponent1SampleBufferReady(Sender: TObject;
      const ATime: Int64);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { private 錾 }
  public
    { public 錾 }
    ac: TStandby;
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses Unit2, DateUtils;

var
  th: TCamThread;

procedure TForm1.Button2Click(Sender: TObject);
begin
  case ac of
  push, shot:
    th.Terminate;
  keep:
    Exit;
  end;
  ac := push;
  th := TCamThread.Create;
  FloatAnimation1.Start;
end;

procedure TForm1.CameraComponent1SampleBufferReady(Sender: TObject;
  const ATime: Int64);
var
  s: string;
  a, b, c, d, e, dd, hh, mm: Word;
  bmp: TBitmap;
begin
  case ac of
    ready, push:
      CameraComponent1.SampleBufferToBitmap(Image1.Bitmap, true);
    shot:
      begin
        ac := keep;
        bmp := TBitmap.Create;
        try
          CameraComponent1.SampleBufferToBitmap(bmp, true);
          Image1.Bitmap.Assign(bmp);
          DecodeDateTime(Now, a, b, dd, hh, d, e, mm);
          s := ExtractFilePath(ParamStr(0)) + Format('%d_%d_%d', [dd, hh, mm]);
          bmp.SaveToFile(s + '.jpg');
        finally
          bmp.Free;
        end;
      end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  CameraComponent1.Quality := TVideoCaptureQuality.HighQuality;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  CameraComponent1.Active := false;
end;

end.
