package hayashi.yuu.register;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.BorderLayout;
import java.io.File;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

import jp.co.areaweb.tools.csv.CsvFile;
import jp.co.areaweb.tools.csv.CsvRecord;

public class SaveDialog extends JDialog implements WindowListener
{
    JLabel label1;
    JButton okButton;
    JLabel label2;
    JFrame parent;

    public SaveDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        addWindowListener(this);
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        this.parent = parent;
        setTitle("登録データの保存");
        getContentPane().setLayout(new BorderLayout());
        setSize(360,180);

        label1 = new JLabel("登録データの設定変更を保存します。", JLabel.CENTER);
        label1.setBounds(10,10,340,20);
        add(label1, BorderLayout.NORTH);

        File outfile = CardRegister.taglistFile.getFile();
        label2 = new JLabel(outfile.getAbsolutePath(), JLabel.CENTER);
        label2.setBounds(10,40,340,20);
        add(label2, BorderLayout.CENTER);

		/*
		 * [OK]ボタン　:　このダイアログウインドウを閉じる
		 */
		okButton = new JButton("OK");
        okButton.setBounds(145,65,66,27);
        okButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
        		// メインパネルに表示されているデータ内容をタグ定義ファイルに書き出す。
        		TableModel model = CardRegister.recordTable.getModel();
        		int rowCnt = model.getRowCount();
        		for (int i=0; i < rowCnt; i++) {
        			String idStr = (String)CardRegister.recordTable.getValueAt(i, 1);
        			String addr = (String)CardRegister.recordTable.getValueAt(i, 2);
        			String name = (String)CardRegister.recordTable.getValueAt(i, 3);
        			CsvFile csvf = CardRegister.taglistFile.find(0, idStr);
        			if (csvf.isEmpty()) {
        				// 新規タグ
        				CsvRecord line = new CsvRecord();
        				line.add(idStr);
        				line.add(addr);
        				line.add(name);
        				CardRegister.taglistFile.add(line);
        			}
        			else {
        				// 既存タグ
        				CsvRecord line = csvf.getFirst();
        				if (!addr.equals(line.get(1))) {
            				line.set(1, addr);	// アドレスの変更
        				}
        				if (!name.equals(line.get(2))) {
            				line.set(2, name);	// なまえの変更
        				}
        			}
        		}

        		try {
					CardRegister.taglistFile.save();
				}
        		catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

        		// このダイアログウインドウを閉じる
        		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(SaveDialog.this, WindowEvent.WINDOW_CLOSING));
        		setVisible(false);
        	}
        });
        JPanel southPanel = new JPanel();
        southPanel.add(okButton);
        add(southPanel, BorderLayout.SOUTH);

        setVisible(true);
    }

    /**
    * Shows or hides the component depending on the boolean flag b.
    * @param b  if true, show the component; otherwise, hide the component.
    * @see java.awt.Component#isVisible
    */
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();
            setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
            bounds.y + (bounds.height - abounds.height)/2);
        }
        super.setVisible(b);
    }

	public void windowClosed(WindowEvent e) {
		setVisible(false);
    }

	public void windowActivated(WindowEvent arg0) {
	}

	public void windowClosing(WindowEvent arg0) {
		setVisible(false);
	}

	public void windowDeactivated(WindowEvent arg0) {
	}

	public void windowDeiconified(WindowEvent arg0) {
	}

	public void windowIconified(WindowEvent arg0) {
	}

	public void windowOpened(WindowEvent arg0) {
	}
}
