/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.util.BeanPropertiesUtilities;
import charactermanaj.util.ConfigurationDirUtilities;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppConfig {
    private static final String CONFIG_NAME = "appConfig.xml";
    public static final String COMMON_CHARACTER_DIR_PROPERTY_NAME = "character.dir";
    private static final String DEFAULT_SPECIFICATION_VERSION = "1.0";
    private static final Logger logger = Logger.getLogger(AppConfig.class.getName());
    private static final AppConfig singleton = new AppConfig();
    private String implementationVersion;
    private String specificationVersion;
    private Color sampleImageBgColor = Color.white;
    private Color defaultImageBgColor = Color.white;
    private Color checkedItemBgColor = Color.cyan.brighter();
    private Color selectedItemBgColor = Color.orange;
    private Color invalidBgColor = Color.red.brighter().brighter();
    private float compressionQuality = 0.8f;
    private Color exportPresetWarningsForegroundColor = Color.red;
    private int jarTransferBufferSize = 4096;
    private String zipNameEncoding = "csWindows31J";
    private Color disabledCellForegroundColor = Color.gray;
    private int dirWatchInterval = 7000;
    private boolean enableDirWatch = true;
    private int fileTransferBufferSize = 4096;
    private long previewIndeicatorDelay = 300L;
    private boolean informationDialogOpenMethod = true;
    private boolean noRemoveLog = false;
    private Color gridColor = Color.gray;
    private boolean enableAutoColorChange = true;
    Color authorEditConflictBgColor = Color.yellow;
    private int mainFrameMaxWidth = 800;
    private int mainFrameMaxHeight = 600;
    private boolean notDisableLayerTab;
    private long purgeLogDays = 10L;
    private String partsColorGroupPattern = "^.*\\(@\\).*$";
    private Color selectPanelTitleColor = Color.BLUE;
    private boolean enableAutoShrinkPanel;
    private boolean disableWatchDirIfNotWritable = true;
    private boolean enablePNGSupportForWindows = true;
    private double renderingOptimizeThresholdForNormal = 2.0;
    private double renderingOptimizeThresholdForCheck = 0.0;
    private boolean enableInterpolationBicubic = true;
    private String predefinedZoomRanges = "20, 50, 80, 100, 120, 150, 200, 300, 400, 800";
    private boolean enableZoomPanel = true;
    private int zoomPanelActivationArea = 30;
    private boolean enableRenderingHints = true;
    private int drawGridMask = 2;
    private int previewGridColor = 0x7F7F0000;
    private int previewGridSize = 20;
    private int previewUnfilledSpaceForCheckMode = 0;
    private boolean enableCheckInfoTooltip = true;
    private int wheelScrollUnit = 10;
    private boolean enableOffscreenWallpaper = false;
    private int offscreenWallpaperSize = 300;

    public static AppConfig getInstance() {
        return singleton;
    }

    private AppConfig() {
        this.loadAppVersions();
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    private void loadAppVersions() {
        Package pak = this.getClass().getPackage();
        String implementationVersion = "develop";
        String specificationVersion = DEFAULT_SPECIFICATION_VERSION;
        if (pak != null) {
            String specVInfo;
            String vInfo = pak.getImplementationVersion();
            if (vInfo != null && implementationVersion.trim().length() > 0) {
                implementationVersion = vInfo.trim();
            }
            if ((specVInfo = pak.getSpecificationVersion()) != null && specVInfo.trim().length() > 0) {
                specificationVersion = specVInfo.trim();
            }
        }
        this.implementationVersion = implementationVersion;
        this.specificationVersion = specificationVersion;
    }

    public List<URI> getCandidateURIs() throws IOException {
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(new File(this.getClass().getResource("/appConfig.xml").getPath()).toURI());
        String specifiedAppConfig = System.getProperty("appConfigFile");
        if (specifiedAppConfig != null) {
            if (specifiedAppConfig.trim().length() > 0) {
                File specifiedAppConfigFile = new File(specifiedAppConfig);
                uris.add(specifiedAppConfigFile.toURI());
            }
        } else {
            File codeBase = ConfigurationDirUtilities.getApplicationBaseDir();
            File userDataDir = ConfigurationDirUtilities.getUserDataDir();
            uris.add(new File(codeBase, CONFIG_NAME).getCanonicalFile().toURI());
            uris.add(new File(userDataDir, CONFIG_NAME).toURI());
        }
        return uris;
    }

    public List<File> getPrioritySaveFileList() {
        ArrayList<File> saveFiles = new ArrayList<File>();
        String specifiedAppConfig = System.getProperty("appConfigFile");
        if (specifiedAppConfig != null) {
            File specifiedAppConfigFile;
            if (specifiedAppConfig.trim().length() > 0 && (!(specifiedAppConfigFile = new File(specifiedAppConfig)).exists() || specifiedAppConfigFile.canWrite())) {
                saveFiles.add(specifiedAppConfigFile);
            }
        } else {
            File userDataDir = ConfigurationDirUtilities.getUserDataDir();
            saveFiles.add(new File(userDataDir, CONFIG_NAME));
        }
        return saveFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        Properties config = new Properties();
        try {
            for (URI uri : this.getCandidateURIs()) {
                File file;
                if (uri == null) continue;
                if ("file".equals(uri.getScheme()) && !(file = new File(uri)).exists()) {
                    logger.log(Level.CONFIG, "appConfig.xml is not found.:" + file);
                    continue;
                }
                try {
                    URL resourceURL = uri.toURL();
                    InputStream is = resourceURL.openStream();
                    try {
                        config.loadFromXML(is);
                        logger.log(Level.CONFIG, "appConfig.xml is loaded.:" + uri);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.CONFIG, "appConfig.xml is not found.: " + uri, ex);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "appConfig.xml loading failed.: " + uri, ex);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("appConfig.xml loading failed.", ex);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("appConfig.xml loading failed.", ex);
        }
        BeanPropertiesUtilities.loadFromProperties(this, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(List<File> prioritySaveFiles) throws IOException {
        Properties config = this.getProperties();
        IOException oex = null;
        for (File configStore : prioritySaveFiles) {
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(configStore));
                try {
                    config.storeToXML((OutputStream)os, CONFIG_NAME, "UTF-8");
                    return;
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u8a2d\u5b9a\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + ex, ex);
                oex = ex;
            }
        }
        if (oex != null) {
            throw oex;
        }
    }

    public void saveConfig() throws IOException {
        this.saveConfig(this.getPrioritySaveFileList());
    }

    public static Set<String> checkProperties(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        AppConfig dummy = new AppConfig();
        return BeanPropertiesUtilities.loadFromProperties(dummy, props);
    }

    public Set<String> update(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        return BeanPropertiesUtilities.loadFromProperties(this, props);
    }

    public Properties getProperties() {
        Properties config = new Properties();
        BeanPropertiesUtilities.saveToProperties(this, config);
        return config;
    }

    public Color getSampleImageBgColor() {
        return this.sampleImageBgColor;
    }

    public void setSampleImageBgColor(Color sampleImageBgColor) {
        if (sampleImageBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.sampleImageBgColor = sampleImageBgColor;
    }

    public Color getDefaultImageBgColor() {
        return this.defaultImageBgColor;
    }

    public void setDefaultImageBgColor(Color defaultImageBgColor) {
        if (defaultImageBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.defaultImageBgColor = defaultImageBgColor;
    }

    public Color getCheckedItemBgColor() {
        return this.checkedItemBgColor;
    }

    public void setCheckedItemBgColor(Color checkedItemBgColor) {
        if (checkedItemBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.checkedItemBgColor = checkedItemBgColor;
    }

    public Color getSelectedItemBgColor() {
        return this.selectedItemBgColor;
    }

    public void setSelectedItemBgColor(Color selectedItemBgColor) {
        this.selectedItemBgColor = selectedItemBgColor;
    }

    public Color getInvalidBgColor() {
        return this.invalidBgColor;
    }

    public void setInvalidBgColor(Color invalidBgColor) {
        if (invalidBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.invalidBgColor = invalidBgColor;
    }

    public float getCompressionQuality() {
        return this.compressionQuality;
    }

    public void setCompressionQuality(float compressionQuality) {
        if (compressionQuality < 0.1f || compressionQuality > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.compressionQuality = compressionQuality;
    }

    public Color getExportPresetWarningsForegroundColor() {
        return this.exportPresetWarningsForegroundColor;
    }

    public void setExportPresetWarningsForegroundColor(Color exportPresetWarningsForegroundColor) {
        this.exportPresetWarningsForegroundColor = exportPresetWarningsForegroundColor;
    }

    public int getJarTransferBufferSize() {
        return this.jarTransferBufferSize;
    }

    public void setJarTransferBufferSize(int jarTransferBufferSize) {
        if (jarTransferBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.jarTransferBufferSize = jarTransferBufferSize;
    }

    public String getZipNameEncoding() {
        return this.zipNameEncoding;
    }

    public void setZipNameEncoding(String zipNameEncoding) {
        if (zipNameEncoding == null) {
            throw new IllegalArgumentException();
        }
        try {
            Charset.forName(zipNameEncoding);
        }
        catch (Exception ex) {
            throw new RuntimeException("unsupported charset: " + zipNameEncoding);
        }
        this.zipNameEncoding = zipNameEncoding;
    }

    public Color getDisabledCellForgroundColor() {
        return this.disabledCellForegroundColor;
    }

    public void setDisabledCellForegroundColor(Color disabledCellForegroundColor) {
        if (disabledCellForegroundColor == null) {
            throw new IllegalArgumentException();
        }
        this.disabledCellForegroundColor = disabledCellForegroundColor;
    }

    public int getDirWatchInterval() {
        return this.dirWatchInterval;
    }

    public void setDirWatchInterval(int dirWatchInterval) {
        if (dirWatchInterval <= 0) {
            throw new IllegalArgumentException();
        }
        this.dirWatchInterval = dirWatchInterval;
    }

    public boolean isEnableDirWatch() {
        return this.enableDirWatch;
    }

    public void setEnableDirWatch(boolean enableDirWatch) {
        this.enableDirWatch = enableDirWatch;
    }

    public int getFileTransferBufferSize() {
        return this.fileTransferBufferSize;
    }

    public void setFileTransferBufferSize(int fileTransferBufferSize) {
        if (fileTransferBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.fileTransferBufferSize = fileTransferBufferSize;
    }

    public long getPreviewIndicatorDelay() {
        return this.previewIndeicatorDelay;
    }

    public void setPreviewIndeicatorDelay(long previewIndeicatorDelay) {
        if (previewIndeicatorDelay < 0L) {
            throw new IllegalArgumentException();
        }
        this.previewIndeicatorDelay = previewIndeicatorDelay;
    }

    public boolean isInformationDialogOpenMethod() {
        return this.informationDialogOpenMethod;
    }

    public void setInformationDialogOpenMethod(boolean informationDialogOpenMethod) {
        this.informationDialogOpenMethod = informationDialogOpenMethod;
    }

    public boolean isNoRemoveLog() {
        return this.noRemoveLog;
    }

    public void setNoRemoveLog(boolean noRemoveLog) {
        this.noRemoveLog = noRemoveLog;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            throw new IllegalArgumentException();
        }
        this.gridColor = gridColor;
    }

    public boolean isEnableAutoColorChange() {
        return this.enableAutoColorChange;
    }

    public void setEnableAutoColorChange(boolean enableAutoColorChange) {
        this.enableAutoColorChange = enableAutoColorChange;
    }

    public void setAuthorEditConflictBgColor(Color authorEditConflictBgColor) {
        if (authorEditConflictBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.authorEditConflictBgColor = authorEditConflictBgColor;
    }

    public Color getAuthorEditConflictBgColor() {
        return this.authorEditConflictBgColor;
    }

    public void setMainFrameMaxWidth(int width) {
        this.mainFrameMaxWidth = width;
    }

    public int getMainFrameMaxWidth() {
        return this.mainFrameMaxWidth;
    }

    public void setMainFrameMaxHeight(int height) {
        this.mainFrameMaxHeight = height;
    }

    public int getMainFrameMaxHeight() {
        return this.mainFrameMaxHeight;
    }

    public boolean isNotDisableLayerTab() {
        return this.notDisableLayerTab;
    }

    public void setNotDisableLayerTab(boolean notDisableLayerTab) {
        this.notDisableLayerTab = notDisableLayerTab;
    }

    public long getPurgeLogDays() {
        return this.purgeLogDays;
    }

    public void setPurgeLogDays(long purgeLogDays) {
        this.purgeLogDays = purgeLogDays;
    }

    public String getPartsColorGroupPattern() {
        return this.partsColorGroupPattern;
    }

    public void setPartsColorGroupPattern(String pattern) {
        if (pattern != null && pattern.trim().length() > 0) {
            Pattern.compile(pattern);
        }
        this.partsColorGroupPattern = pattern;
    }

    public Color getSelectPanelTitleColor() {
        return this.selectPanelTitleColor;
    }

    public void setSelectPanelTitleColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.selectPanelTitleColor = color;
    }

    public boolean isEnableAutoShrinkPanel() {
        return this.enableAutoShrinkPanel;
    }

    public void setEnableAutoShrinkPanel(boolean enableAutoShrinkPanel) {
        this.enableAutoShrinkPanel = enableAutoShrinkPanel;
    }

    public boolean isDisableWatchDirIfNotWritable() {
        return this.disableWatchDirIfNotWritable;
    }

    public void setDisableWatchDirIfNotWritable(boolean disableWatchDirIfNotWritable) {
        this.disableWatchDirIfNotWritable = disableWatchDirIfNotWritable;
    }

    public void setEnablePNGSupportForWindows(boolean enablePNGSupportForWindows) {
        this.enablePNGSupportForWindows = enablePNGSupportForWindows;
    }

    public boolean isEnablePNGSupportForWindows() {
        return this.enablePNGSupportForWindows;
    }

    public void setRenderingOptimizeThresholdForNormal(double renderingOptimizeThresholdForNormal) {
        this.renderingOptimizeThresholdForNormal = renderingOptimizeThresholdForNormal;
    }

    public double getRenderingOptimizeThresholdForNormal() {
        return this.renderingOptimizeThresholdForNormal;
    }

    public void setRenderingOptimizeThresholdForCheck(double renderingOptimizeThresholdForCheck) {
        this.renderingOptimizeThresholdForCheck = renderingOptimizeThresholdForCheck;
    }

    public double getRenderingOptimizeThresholdForCheck() {
        return this.renderingOptimizeThresholdForCheck;
    }

    public void setEnableInterpolationBicubic(boolean enableInterpolationBicubic) {
        this.enableInterpolationBicubic = enableInterpolationBicubic;
    }

    public boolean isEnableInterpolationBicubic() {
        return this.enableInterpolationBicubic;
    }

    public String getPredefinedZoomRanges() {
        return this.predefinedZoomRanges;
    }

    public void setPredefinedZoomRanges(String predefinedZoomRanges) {
        this.predefinedZoomRanges = predefinedZoomRanges;
    }

    public boolean isEnableZoomPanel() {
        return this.enableZoomPanel;
    }

    public void setEnableZoomPanel(boolean enableZoomPanel) {
        this.enableZoomPanel = enableZoomPanel;
    }

    public int getZoomPanelActivationArea() {
        return this.zoomPanelActivationArea;
    }

    public void setZoomPanelActivationArea(int zoomPanelActivationArea) {
        this.zoomPanelActivationArea = zoomPanelActivationArea;
    }

    public void setEnableRenderingHints(boolean enableRenderingHints) {
        this.enableRenderingHints = enableRenderingHints;
    }

    public boolean isEnableRenderingHints() {
        return this.enableRenderingHints;
    }

    public int getDrawGridMask() {
        return this.drawGridMask;
    }

    public void setDrawGridMask(int drawGridMask) {
        this.drawGridMask = drawGridMask & 3;
    }

    public int getPreviewGridColor() {
        return this.previewGridColor;
    }

    public void setPreviewGridColor(int previewGridColor) {
        this.previewGridColor = previewGridColor;
    }

    public int getPreviewGridSize() {
        return this.previewGridSize;
    }

    public void setPreviewGridSize(int previewGridSize) {
        this.previewGridSize = previewGridSize;
    }

    public int getPreviewUnfilledSpaceForCheckMode() {
        return this.previewUnfilledSpaceForCheckMode;
    }

    public void setPreviewUnfilledSpaceForCheckMode(int previewUnfilledSpaceForCheckMode) {
        this.previewUnfilledSpaceForCheckMode = previewUnfilledSpaceForCheckMode;
    }

    public boolean isEnableCheckInfoTooltip() {
        return this.enableCheckInfoTooltip;
    }

    public void setEnableCheckInfoTooltip(boolean enableCheckInfoTooltip) {
        this.enableCheckInfoTooltip = enableCheckInfoTooltip;
    }

    public int getWheelScrollUnit() {
        return this.wheelScrollUnit;
    }

    public void setWheelScrollUnit(int wheelScrollUnit) {
        this.wheelScrollUnit = wheelScrollUnit;
    }

    public boolean isEnableOffscreenWallpaper() {
        return this.enableOffscreenWallpaper;
    }

    public void setEnableOffscreenWallpaper(boolean enableOffscreenWallpaper) {
        this.enableOffscreenWallpaper = enableOffscreenWallpaper;
    }

    public int getOffscreenWallpaperSize() {
        return this.offscreenWallpaperSize;
    }

    public void setOffscreenWallpaperSize(int offscreenWallpaperSize) {
        this.offscreenWallpaperSize = offscreenWallpaperSize;
    }
}

