/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsDataLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsSpecDecorateLoader
implements PartsDataLoader {
    private PartsDataLoader parent;
    private Collection<ColorGroup> colorGroups;

    public PartsSpecDecorateLoader(PartsDataLoader parent, Collection<ColorGroup> colorGroups) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (colorGroups == null) {
            colorGroups = Collections.emptyList();
        }
        this.parent = parent;
        this.colorGroups = colorGroups;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> load(PartsCategory category) {
        Map<PartsIdentifier, PartsSpec> partsSpecs = this.parent.load(category);
        this.decolatePartsSpec(partsSpecs);
        return partsSpecs;
    }

    protected void decolatePartsSpec(Map<PartsIdentifier, PartsSpec> partsSpecs) {
        String templ = AppConfig.getInstance().getPartsColorGroupPattern();
        if (templ == null || templ.trim().length() == 0) {
            return;
        }
        for (ColorGroup colorGroup : this.colorGroups) {
            String pattern = templ.replace("@", colorGroup.getLocalizedName());
            Pattern pat = Pattern.compile(pattern);
            for (PartsSpec partsSpec : partsSpecs.values()) {
                Matcher mat = pat.matcher(partsSpec.getPartsIdentifier().getLocalizedPartsName());
                if (!mat.matches()) continue;
                partsSpec.setColorGroup(colorGroup);
            }
        }
    }
}

