/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.SetupLocalization;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class ResourceLoader {
    public ClassLoader getClassLoader() {
        return this.getLocalizedClassLoader(this.getDefaultClassLoader());
    }

    public ClassLoader getDefaultClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ResourceLoader.class.getClassLoader();
                }
                return cl;
            }
        });
    }

    public ClassLoader getLocalizedClassLoader(final ClassLoader parent) {
        try {
            File baseDir = ConfigurationDirUtilities.getUserDataDir();
            SetupLocalization localize = new SetupLocalization(baseDir);
            final File resourceDir = localize.getResourceDir();
            if (!resourceDir.exists() || !resourceDir.isDirectory()) {
                return parent;
            }
            URLClassLoader cl = AccessController.doPrivileged(new PrivilegedExceptionAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() throws MalformedURLException {
                    URL[] urls = new URL[]{resourceDir.toURI().toURL()};
                    return new URLClassLoader(urls, parent){

                        public URL getResource(String name) {
                            ClassLoader parent;
                            URL url = this.findResource(name);
                            if (url == null && (parent = this.getParent()) != null) {
                                url = parent.getResource(name);
                            }
                            return url;
                        }
                    };
                }
            });
            return cl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public URL getResource(String name) {
        if (name == null) {
            return null;
        }
        return this.getClassLoader().getResource(name);
    }
}

