/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;

final class ColorConvertedImageKey {
    private final ColorConvertParameter colorConvParameter;
    private final ImageResource imageResource;
    private final long lastModified;
    private final int hashCode;

    public ColorConvertedImageKey(ColorConvertParameter colorConvParameter, ImageResource imageResource) {
        if (colorConvParameter == null || imageResource == null) {
            throw new IllegalArgumentException();
        }
        this.colorConvParameter = colorConvParameter;
        this.imageResource = imageResource;
        this.lastModified = imageResource.lastModified();
        this.hashCode = imageResource.hashCode() ^ colorConvParameter.hashCode() ^ (int)this.lastModified;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ColorConvertedImageKey) {
            ColorConvertedImageKey other = (ColorConvertedImageKey)obj;
            return this.lastModified == other.lastModified && this.imageResource.equals(other.imageResource) && this.colorConvParameter.equals(other.colorConvParameter);
        }
        return false;
    }
}

