/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CharacterDataJarArchiveFile
extends AbstractCharacterDataArchiveFile {
    protected JarFile jarFile;

    public void close() throws IOException {
        this.jarFile.close();
    }

    public CharacterDataJarArchiveFile(File file) throws IOException {
        super(file);
        this.jarFile = new JarFile(file);
        this.load();
    }

    private void load() {
        Enumeration<JarEntry> enm = this.jarFile.entries();
        while (enm.hasMoreElements()) {
            JarEntry entry = enm.nextElement();
            this.addEntry(new JarFileContent(entry));
        }
        this.searchRootPrefix();
    }

    protected class JarFileContent
    implements AbstractCharacterDataArchiveFile.FileContent {
        private JarEntry entry;

        protected JarFileContent(JarEntry entry) {
            this.entry = entry;
        }

        public String getEntryName() {
            return this.entry.getName();
        }

        public long lastModified() {
            return this.entry.getTime();
        }

        public InputStream openStream() throws IOException {
            return CharacterDataJarArchiveFile.this.jarFile.getInputStream(this.entry);
        }
    }
}

